/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jpedal.io.PathSerializer;

public class Vector_Shape
implements Serializable {
    int increment_size = 1000;
    protected int current_item = 0;
    int max_size = 250;
    private Area[] items = new Area[this.max_size];
    private int checkPoint = -1;

    public Vector_Shape() {
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1) {
            this.current_item = this.checkPoint = this.current_item;
        }
    }

    protected int incrementSize(int n) {
        n = n < 8000 ? (n *= 4) : (n < 16000 ? (n *= 2) : (n += 2000));
        return n;
    }

    public Vector_Shape(int n) {
        this.max_size = n;
        this.items = new Area[this.max_size];
    }

    public final Area[] get() {
        return this.items;
    }

    public final void removeElementAt(int n) {
        if (n >= 0) {
            System.arraycopy(this.items, n + 1, this.items, n, this.current_item - 1 - n);
            this.items[this.current_item - 1] = new Area();
        } else {
            this.items[0] = new Area();
        }
        --this.current_item;
    }

    public final boolean contains(Shape shape) {
        return false;
    }

    public final void set(Area[] areaArray) {
        this.items = areaArray;
    }

    public final void clear() {
        this.checkPoint = -1;
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = null;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = null;
            }
        }
        this.current_item = 0;
    }

    public final Area elementAt(int n) {
        if (n >= this.max_size) {
            return null;
        }
        return this.items[n];
    }

    public final void addElement(Area area) {
        this.checkSize(this.current_item);
        this.items[this.current_item] = area;
        ++this.current_item;
    }

    public final int size() {
        return this.current_item + 1;
    }

    public final void setElementAt(Area area, int n) {
        if (n >= this.max_size) {
            this.checkSize(n);
        }
        this.items[n] = area;
    }

    private final void checkSize(int n) {
        if (n >= this.max_size) {
            int n2 = this.max_size;
            this.max_size += this.increment_size;
            if (this.max_size <= n) {
                this.max_size = n + this.increment_size + 2;
            }
            Area[] areaArray = this.items;
            this.items = new Area[this.max_size];
            System.arraycopy(areaArray, 0, this.items, 0, n2);
            this.increment_size = this.incrementSize(this.increment_size);
        }
    }

    public void writeToStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(new Integer(this.max_size));
        for (int i = 0; i < this.max_size; ++i) {
            Area area = this.items[i];
            if (area == null) {
                objectOutputStream.writeObject(null);
                continue;
            }
            PathIterator pathIterator = area.getPathIterator(new AffineTransform());
            PathSerializer.serializePath(objectOutputStream, pathIterator);
        }
    }

    public void restoreFromStream(ByteArrayInputStream byteArrayInputStream) throws IOException, ClassNotFoundException {
        int n;
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        this.max_size = n = ((Integer)objectInputStream.readObject()).intValue();
        this.items = new Area[n];
        for (int i = 0; i < n; ++i) {
            GeneralPath generalPath = PathSerializer.deserializePath(objectInputStream);
            this.items[i] = generalPath == null ? null : new Area(generalPath);
        }
    }

    public void trim() {
        Area[] areaArray = new Area[this.current_item];
        System.arraycopy(this.items, 0, areaArray, 0, this.current_item);
        this.items = areaArray;
        this.max_size = this.current_item;
    }

    public void setSize(int n) {
        this.current_item = n;
    }
}

