/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.math.BigDecimal;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class RoundHalfToEven
extends OXMLFunction {
    private int numParams;

    RoundHalfToEven(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "round-half-to-even";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.NUMERIC_ZERO_OR_ONE;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.NUMERIC_ZERO_OR_ONE;
        }
        if (n == 1) {
            return OXMLSequenceType.TINTEGER;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequence2);
        int n = oXMLItem.getInt();
        return this.round(oXMLFunctionContext, oXMLSequence, n);
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        return this.round(oXMLFunctionContext, oXMLSequence, 0);
    }

    private OXMLSequence round(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, int n) throws XQException {
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem != null) {
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            int n2 = oXMLItem.getPrimitiveType();
            OXMLSequenceType oXMLSequenceType = OXMLSequenceType.getConstantType(1, n2);
            if (n2 == 3 || n2 == 4) {
                double d = oXMLItem.getDouble();
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    oXMLItem2.setDouble(oXMLSequenceType, d);
                    oXMLSequence2.appendItem(oXMLItem2);
                } else {
                    oXMLItem2.setDouble(oXMLSequenceType, this.round2Even(d, n));
                    oXMLSequence2.appendItem(oXMLItem2);
                }
            } else if (n2 == 5 || n2 == 22) {
                double d = oXMLItem.withinRange() ? (double)oXMLItem.getInt() : oXMLItem.getDecimal().doubleValue();
                BigDecimal bigDecimal = new BigDecimal(this.round2Even(d, n));
                if (n > 0) {
                    bigDecimal = bigDecimal.setScale(n, 6);
                }
                oXMLItem2.setDecimal(oXMLSequenceType, bigDecimal);
                oXMLSequence2.appendItem(oXMLItem2);
            }
        }
        return oXMLSequence2;
    }

    private double round2Even(double d, int n) {
        double d2;
        double d3 = Math.pow(10.0, 0 - n);
        double d4 = d / d3;
        d4 = d4 - (d2 = Math.floor(d4)) == 0.5 ? (d2 % 2.0 != 0.0 ? d2 + 1.0 : d2) : Math.floor(d4 + 0.5);
        return d4 * d3;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        oXMLSequence = oXMLSequenceArray.length == 1 ? this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]) : this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
        return oXMLSequence;
    }
}

