/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3;

import net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3.MP3;
import net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3.data.HuffmanCodes;
import net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3.data.HuffmanQuadCodes0;
import net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3.data.HuffmanQuadCodes1;
import net.sourceforge.jffmpeg.codecs.audio.mpeg.mp3.data.Table;
import net.sourceforge.jffmpeg.codecs.utils.BitStream;
import net.sourceforge.jffmpeg.codecs.utils.FFMpegException;

public class Granule {
    public static final boolean debug = false;
    public static final int SBLIMIT = 32;
    private int granuleStartPosition;
    private int scfsi;
    private int part23Length;
    private int bigValues;
    private int globalGain;
    private int scaleFactorCompress;
    private boolean blockSplitFlag;
    private int blockType;
    private boolean switchPoint;
    private int[] tableSelect = new int[3];
    private int[] subBlockGain = new int[3];
    private int preflag;
    private int scaleFacScale;
    private int count1TableSelect;
    private int region_address1;
    private int region_address2;
    private int[] scaleFactors = new int[40];
    private int[] exponents = new int[576];
    private int[] sb_hybrid = new int[576];
    private int[] slenTable1 = Table.getSlenTable1();
    private int[] slenTable2 = Table.getSlenTable2();
    private int[][] band_size_long = Table.getBandSizeLong();
    private int[][] band_size_short = Table.getBandSizeShort();
    private int[][] mpa_pretab = Table.getPreTab();
    private int[][] band_index_long = Table.getBandIndexLong();
    private int[][] mpa_huff_data = Table.getHuffData();
    HuffmanCodes[] huff_vlc = HuffmanCodes.getHuffmanCodes();
    HuffmanCodes[] huff_quad_vlc = new HuffmanCodes[]{new HuffmanQuadCodes0(), new HuffmanQuadCodes1()};
    private int[][][] lsf_nsf_table = Table.getLsfNsfTable();
    private int longEnd;
    private int shortStart;
    private int[] gains = new int[3];
    final int ISQRT2 = 5931642;
    private boolean[] non_zero_found_short = new boolean[3];
    public static final int FRAC_BITS = 23;
    public static final int WFRAC_BITS = 16;
    public static final int FRAC_ONE = 0x800000;
    public int[] scale_factor_mult3 = new int[]{0x800000, 9975792, 11863283, 14107901};
    private int[] regionSize = new int[3];
    private int[] tmp = new int[576];
    public static final int TABLE_4_3_SIZE = 8207;
    public static final int[] table_4_3_value;
    public static final int[] table_4_3_exp;
    private static int[][] is_table;
    private static int[][][] is_table_lsf;
    private static int[] csa_table;
    public static final double M_PI = Math.PI;
    private static double[] ci_table;

    public int getScfsi() {
        return this.scfsi;
    }

    public void setScfsi(int n) {
        this.scfsi = n;
    }

    public void read(BitStream bitStream, boolean bl, int n) {
        this.part23Length = bitStream.getBits(12);
        this.bigValues = bitStream.getBits(9);
        this.globalGain = bitStream.getBits(8);
        if ((n & 3) == 2) {
            this.globalGain -= 2;
        }
        this.scaleFactorCompress = bitStream.getBits(bl ? 9 : 4);
        this.blockSplitFlag = bitStream.getTrueFalse();
        if (this.blockSplitFlag) {
            this.blockType = bitStream.getBits(2);
            this.switchPoint = bitStream.getTrueFalse();
            this.tableSelect[0] = bitStream.getBits(5);
            this.tableSelect[1] = bitStream.getBits(5);
            this.subBlockGain[0] = bitStream.getBits(3);
            this.subBlockGain[1] = bitStream.getBits(3);
            this.subBlockGain[2] = bitStream.getBits(3);
        } else {
            this.blockType = 0;
            this.tableSelect[0] = bitStream.getBits(5);
            this.tableSelect[1] = bitStream.getBits(5);
            this.tableSelect[2] = bitStream.getBits(5);
            this.region_address1 = bitStream.getBits(4);
            this.region_address2 = bitStream.getBits(3);
        }
        this.preflag = bl ? 0 : bitStream.getBits(1);
        this.scaleFacScale = bitStream.getBits(1);
        this.count1TableSelect = bitStream.getBits(1);
    }

    private final void lsf_sf_expand(int[] nArray, int n, int n2, int n3, int n4) {
        if (n4 != 0) {
            nArray[3] = n % n4;
            n /= n4;
        } else {
            nArray[3] = 0;
        }
        if (n3 != 0) {
            nArray[2] = n % n3;
            n /= n3;
        } else {
            nArray[2] = 0;
        }
        nArray[1] = n % n2;
        nArray[0] = n /= n2;
    }

    public void readScaleFactors(BitStream bitStream, boolean bl, Granule granule, int n, int n2) {
        this.granuleStartPosition = bitStream.getPos();
        if (!bl) {
            int n3 = this.slenTable1[this.scaleFactorCompress];
            int n4 = this.slenTable2[this.scaleFactorCompress];
            if (this.blockType == 2) {
                int n5;
                int n6 = 0;
                for (n5 = 0; n5 < (this.switchPoint ? 17 : 18); ++n5) {
                    this.scaleFactors[n6++] = bitStream.getBits(n3);
                }
                for (n5 = 0; n5 < 18; ++n5) {
                    this.scaleFactors[n6++] = bitStream.getBits(n4);
                }
                this.scaleFactors[n6++] = 0;
                this.scaleFactors[n6++] = 0;
                this.scaleFactors[n6++] = 0;
            } else {
                int n7 = 0;
                for (int i = 0; i < 4; ++i) {
                    int n8;
                    int n9;
                    int n10 = n9 = i == 0 ? 6 : 5;
                    if ((this.scfsi & 8 >> i) == 0) {
                        for (n8 = 0; n8 < n9; ++n8) {
                            this.scaleFactors[n7++] = bitStream.getBits(i < 2 ? n3 : n4);
                        }
                        continue;
                    }
                    for (n8 = 0; n8 < n9; ++n8) {
                        this.scaleFactors[n7] = granule.scaleFactors[n7];
                        ++n7;
                    }
                }
                this.scaleFactors[n7++] = 0;
            }
        } else {
            int n11 = 0;
            int n12 = 0;
            if (this.blockType == 2) {
                n11 = this.switchPoint ? 2 : 1;
            }
            int n13 = this.scaleFactorCompress;
            int[] nArray = new int[4];
            if ((n2 & 1) != 0 && n == 1) {
                if ((n13 >>= 1) < 180) {
                    this.lsf_sf_expand(nArray, n13, 6, 6, 0);
                    n12 = 3;
                } else if (n13 < 244) {
                    this.lsf_sf_expand(nArray, n13 - 180, 4, 4, 0);
                    n12 = 4;
                } else {
                    this.lsf_sf_expand(nArray, n13 - 244, 3, 0, 0);
                    n12 = 5;
                }
            } else if (n13 < 400) {
                this.lsf_sf_expand(nArray, n13, 5, 4, 4);
                n12 = 0;
            } else if (n13 < 500) {
                this.lsf_sf_expand(nArray, n13 - 400, 5, 4, 0);
                n12 = 1;
            } else {
                this.lsf_sf_expand(nArray, n13 - 500, 3, 0, 0);
                n12 = 2;
                this.preflag = 1;
            }
            int n14 = 0;
            for (int i = 0; i < 4; ++i) {
                int n15 = this.lsf_nsf_table[n12][n11][i];
                int n16 = nArray[i];
                for (int j = 0; j < n15; ++j) {
                    this.scaleFactors[n14++] = bitStream.getBits(n16);
                }
            }
            while (n14 < 40) {
                this.scaleFactors[n14] = 0;
                ++n14;
            }
        }
    }

    public void exponents_from_scale_factors(int n) {
        int n2;
        int n3;
        int n4;
        this.longEnd = 0;
        this.shortStart = 0;
        if (this.blockType == 2) {
            if (this.switchPoint) {
                if (n <= 2) {
                    this.longEnd = 8;
                    this.shortStart = 2;
                } else if (n != 8) {
                    this.longEnd = 6;
                    this.shortStart = 3;
                } else {
                    this.longEnd = 4;
                    this.shortStart = 2;
                }
            }
        } else {
            this.longEnd = 22;
            this.shortStart = 13;
        }
        int n5 = 0;
        int n6 = this.globalGain - 210;
        int n7 = this.scaleFacScale + 1;
        int[] nArray = this.band_size_long[n];
        int[] nArray2 = this.mpa_pretab[this.preflag];
        for (n4 = 0; n4 < this.longEnd; ++n4) {
            n3 = n6 - (this.scaleFactors[n4] + nArray2[n4] << n7);
            for (n2 = nArray[n4]; n2 > 0; --n2) {
                this.exponents[n5++] = n3;
            }
        }
        if (this.blockType == 2) {
            nArray = this.band_size_short[n];
            this.gains[0] = n6 - (this.subBlockGain[0] << 3);
            this.gains[1] = n6 - (this.subBlockGain[1] << 3);
            this.gains[2] = n6 - (this.subBlockGain[2] << 3);
            n4 = this.longEnd;
            for (n3 = this.shortStart; n3 < 13; ++n3) {
                n2 = nArray[n3];
                for (int i = 0; i < 3; ++i) {
                    int n8 = this.gains[i] - (this.scaleFactors[n4++] << n7);
                    for (int j = nArray[n3]; j > 0; --j) {
                        this.exponents[n5++] = n8;
                    }
                }
            }
        }
    }

    private final int MULL(int n, int n2) {
        return (int)((long)n * (long)n2 >> 23);
    }

    public void computeStereo(MP3 mP3, Granule granule) {
        block18: {
            block17: {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int[][] nArray;
                if (mP3.mode_ext != 1) break block17;
                if (!mP3.lsf) {
                    nArray = is_table;
                    n9 = 7;
                } else {
                    nArray = is_table_lsf[this.scaleFactorCompress & 1];
                    n9 = 16;
                }
                int n10 = 576;
                int n11 = 576;
                this.non_zero_found_short[0] = false;
                this.non_zero_found_short[1] = false;
                this.non_zero_found_short[2] = false;
                int n12 = (13 - this.shortStart) * 3 + this.longEnd - 3;
                for (n8 = 12; n8 >= this.shortStart; --n8) {
                    if (n8 != 11) {
                        n12 -= 3;
                    }
                    n7 = this.band_size_short[mP3.sample_rate_index][n8];
                    for (n6 = 2; n6 >= 0; --n6) {
                        n10 -= n7;
                        n11 -= n7;
                        if (!this.non_zero_found_short[n6]) {
                            for (n5 = 0; n5 < n7; ++n5) {
                                if (this.sb_hybrid[n11 + n5] == 0) continue;
                                this.non_zero_found_short[n6] = true;
                                break;
                            }
                        }
                        if (!this.non_zero_found_short[n6] && (n5 = this.scaleFactors[n12 + 1]) < n9) {
                            n4 = nArray[0][n5];
                            n3 = nArray[1][n5];
                            for (n2 = 0; n2 < n7; ++n2) {
                                n = granule.sb_hybrid[n10 + n2];
                                granule.sb_hybrid[n10 + n2] = this.MULL(n, n4);
                                this.sb_hybrid[n11 + n2] = this.MULL(n, n3);
                            }
                            continue;
                        }
                        if (mP3.mode_ext != 2) continue;
                        for (n5 = 0; n5 < n7; ++n5) {
                            n4 = granule.sb_hybrid[n10 + n5];
                            n3 = this.sb_hybrid[n11 + n5];
                            granule.sb_hybrid[n10 + n5] = this.MULL(n4 + n3, 5931642);
                            this.sb_hybrid[n11 + n5] = this.MULL(n4 - n3, 5931642);
                        }
                    }
                }
                n8 = this.non_zero_found_short[0] | this.non_zero_found_short[1] | this.non_zero_found_short[2];
                for (n7 = this.longEnd - 1; n7 >= 0; --n7) {
                    n6 = this.band_size_long[mP3.sample_rate_index][n7];
                    n10 -= n6;
                    n11 -= n6;
                    if (n8 == 0) {
                        for (n5 = 0; n5 < n6; ++n5) {
                            if (this.sb_hybrid[n11 + n5] == 0) continue;
                            n8 = 1;
                            break;
                        }
                    }
                    if (n8 == 0 && (n5 = this.scaleFactors[n12 = n7 == 21 ? 20 : n7]) < n9) {
                        n4 = nArray[0][n5];
                        n3 = nArray[1][n5];
                        for (n2 = 0; n2 < n6; ++n2) {
                            n = granule.sb_hybrid[n10 + n2];
                            granule.sb_hybrid[n10 + n2] = this.MULL(n, n4);
                            this.sb_hybrid[n11 + n2] = this.MULL(n, n3);
                        }
                        continue;
                    }
                    if (mP3.mode_ext != 2) continue;
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = granule.sb_hybrid[n10 + n5];
                        n3 = this.sb_hybrid[n11 + n5];
                        granule.sb_hybrid[n10 + n5] = this.MULL(n4 + n3, 5931642);
                        this.sb_hybrid[n11 + n5] = this.MULL(n4 - n3, 5931642);
                    }
                }
                break block18;
            }
            if (mP3.mode_ext != 2) break block18;
            for (int i = 0; i < 576; ++i) {
                int n = granule.sb_hybrid[i];
                int n13 = this.sb_hybrid[i];
                granule.sb_hybrid[i] = n + n13;
                this.sb_hybrid[i] = n - n13;
            }
        }
    }

    public final int[] getSbHybrid() {
        return this.sb_hybrid;
    }

    public final int getBlockType() {
        return this.blockType;
    }

    public boolean getSwitchPoint() {
        return this.switchPoint;
    }

    private int l3_unscale(int n, int n2) {
        int n3 = 23 - (table_4_3_exp[n] + (n2 >> 2));
        long l = (long)table_4_3_value[n] * (long)this.scale_factor_mult3[n2 & 3];
        long l2 = l + (1L << n3 - 1) >> n3;
        return (int)l2;
    }

    public void huffman_decode(BitStream bitStream, int n) throws FFMpegException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.blockSplitFlag) {
            this.regionSize[0] = this.blockType == 2 ? 18 : (n <= 2 ? 18 : (n != 8 ? 27 : 54));
            this.regionSize[1] = 288;
        } else {
            this.regionSize[0] = this.band_index_long[n][this.region_address1 + 1] >> 1;
            n7 = this.region_address1 + this.region_address2 + 2;
            if (n7 > 22) {
                n7 = 22;
            }
            this.regionSize[1] = this.band_index_long[n][n7] >> 1;
        }
        this.regionSize[2] = 288;
        n7 = 0;
        for (n6 = 0; n6 < 3; ++n6) {
            n5 = this.regionSize[n6];
            if (n5 > this.bigValues) {
                n5 = this.bigValues;
            }
            this.regionSize[n6] = n5 - n7;
            n7 = n5;
        }
        n6 = 0;
        for (n5 = 0; n5 < 3; ++n5) {
            n4 = this.regionSize[n5];
            if (n4 == 0) continue;
            n3 = this.tableSelect[n5];
            n2 = this.mpa_huff_data[n3][0];
            int n8 = this.mpa_huff_data[n3][1];
            HuffmanCodes huffmanCodes = this.huff_vlc[n2];
            int[] nArray = huffmanCodes.getHuffCodeTable();
            while (n4 > 0) {
                int n9;
                int n10 = 0;
                int n11 = 0;
                if (nArray != null) {
                    n9 = bitStream.getVLC(huffmanCodes);
                    n11 = nArray[n9];
                    n10 = n11 >> 4;
                    n11 &= 0xF;
                }
                n9 = 0;
                if (n10 != 0) {
                    if (n10 == 15) {
                        n10 += bitStream.getBits(n8);
                    }
                    n9 = this.l3_unscale(n10, this.exponents[n6]);
                    n9 = bitStream.getTrueFalse() ? -n9 : n9;
                }
                this.sb_hybrid[n6++] = n9;
                n9 = 0;
                if (n11 != 0) {
                    if (n11 == 15) {
                        n11 += bitStream.getBits(n8);
                    }
                    n9 = this.l3_unscale(n11, this.exponents[n6]);
                    n9 = bitStream.getTrueFalse() ? -n9 : n9;
                }
                this.sb_hybrid[n6++] = n9;
                --n4;
            }
        }
        HuffmanCodes huffmanCodes = this.huff_quad_vlc[this.count1TableSelect];
        while (n6 < 572 && bitStream.getPos() < this.granuleStartPosition + this.part23Length) {
            n4 = bitStream.getVLC(huffmanCodes);
            for (n3 = 0; n3 < 4; ++n3) {
                n2 = 0;
                if ((n4 & 8 >> n3) != 0) {
                    n2 = this.l3_unscale(1, this.exponents[n6]);
                    n2 = bitStream.getTrueFalse() ? -n2 : n2;
                }
                this.sb_hybrid[n6++] = n2;
            }
        }
        while (n6 < 572) {
            this.sb_hybrid[n6++] = 0;
        }
        bitStream.seek(this.part23Length + this.granuleStartPosition);
    }

    public void reorderBlock(MP3 mP3) {
        if (this.blockType == 2) {
            int n = 0;
            if (this.switchPoint) {
                n = mP3.sample_rate_index != 8 ? 36 : 48;
            }
            int n2 = 0;
            for (int i = this.shortStart; i < 13; ++i) {
                int n3 = this.band_size_short[mP3.sample_rate_index][i];
                int n4 = n;
                for (int j = 0; j < 3; ++j) {
                    n2 = j;
                    for (int k = n3; k > 0; --k) {
                        this.tmp[n2] = this.sb_hybrid[n++];
                        n2 += 3;
                    }
                }
                System.arraycopy(this.tmp, 0, this.sb_hybrid, n4, n3 * 3);
            }
        }
    }

    public void antialias(MP3 mP3) {
        int n;
        if (this.blockType == 2) {
            if (!this.switchPoint) {
                return;
            }
            n = 1;
        } else {
            n = 31;
        }
        int n2 = 18;
        for (int i = n; i > 0; --i) {
            int n3 = n2 - 1;
            int n4 = n2;
            for (int j = 0; j < 8; ++j) {
                int n5 = this.sb_hybrid[n3];
                int n6 = this.sb_hybrid[n4];
                this.sb_hybrid[n3--] = (int)(0x400000L + ((long)n5 * (long)csa_table[j * 2] - (long)n6 * (long)csa_table[j * 2 + 1]) >> 23);
                this.sb_hybrid[n4++] = (int)(0x400000L + ((long)n5 * (long)csa_table[j * 2 + 1] + (long)n6 * (long)csa_table[j * 2]) >> 23);
            }
            n2 += 18;
        }
    }

    public void dumpScaleFactors() {
        System.out.println("scfsi=" + Integer.toHexString(this.scfsi) + " scale_factors:");
        for (int i = 0; i < this.scaleFactors.length; ++i) {
            System.out.print(" " + this.scaleFactors[i]);
        }
        System.out.println();
    }

    public void dumpHybrid() {
        for (int i = 0; i < 576; ++i) {
            System.out.print(" " + this.sb_hybrid[i]);
            if (i % 18 != 17) continue;
            System.out.println();
        }
    }

    public String toString() {
        return "scfsi " + this.scfsi + "\n" + "tableSelect[0] " + this.tableSelect[0];
    }

    public static final double sin(double d) {
        return Math.sin(d);
    }

    public static final double tan(double d) {
        return Math.tan(d);
    }

    public static final double pow(double d, double d2) {
        return Math.pow(d, d2);
    }

    public static final double sqrt(double d) {
        return Math.sqrt(d);
    }

    static {
        int n;
        int n2;
        int n3;
        table_4_3_value = new int[8207];
        table_4_3_exp = new int[8207];
        int[] nArray = new int[]{0x1000000, 21137967, 26632170};
        int[] nArray2 = new int[13];
        int n4 = 0x1000000;
        for (n3 = 0; n3 < 13; ++n3) {
            n2 = (0x1555555 - n3 * 0x1000000) / (n3 + 1);
            nArray2[n3] = n4 = (int)((long)n4 * (long)n2 >> 24);
        }
        for (n3 = 1; n3 < 8207; ++n3) {
            int n5;
            n2 = n3;
            int n6 = 24;
            while (n2 < 0x800000) {
                n2 <<= 1;
                --n6;
            }
            n2 -= 0x1000000;
            int n7 = 0;
            for (n5 = 12; n5 >= 0; --n5) {
                n7 = (int)((long)n2 * ((long)nArray2[n5] + (long)n7) >> 24);
            }
            n2 = 0x1000000 + n7;
            n5 = (n6 *= 4) % 3;
            int n8 = n6 / 3;
            n2 = (int)((long)n2 * (long)nArray[n5] >> 24);
            while (n2 >= 0x2000000) {
                n2 >>= 1;
                ++n8;
            }
            while (n2 < 0x1000000) {
                n2 <<= 1;
                --n8;
            }
            ++n2;
            n2 >>= 1;
            while (n2 >= 0x1000000) {
                n2 >>= 1;
                ++n8;
            }
            Granule.table_4_3_value[n3] = n2;
            Granule.table_4_3_exp[n3] = n8;
        }
        ci_table = new double[]{-0.6, -0.535, -0.33, -0.185, -0.095, -0.041, -0.0142, -0.0037};
        is_table = new int[2][16];
        for (n = 0; n < 7; ++n) {
            int n9;
            if (n != 6) {
                double d = Granule.tan((double)n * Math.PI / 12.0);
                n9 = (int)(8388608.0 * (d / (1.0 + d)) + 0.5);
            } else {
                n9 = 0x800000;
            }
            Granule.is_table[0][n] = n9;
            Granule.is_table[1][6 - n] = n9;
        }
        for (n = 7; n < 16; ++n) {
            Granule.is_table[0][n] = 0;
            Granule.is_table[1][n] = 0;
        }
        is_table_lsf = new int[2][2][16];
        for (n = 0; n < 16; ++n) {
            for (int i = 0; i < 2; ++i) {
                int n10 = -(i + 1) * (n + 1 >> 1);
                double d = Granule.pow(2.0, (double)n10 / 4.0);
                n4 = n & 1;
                Granule.is_table_lsf[i][n4 ^ 1][n] = (int)(8388608.0 * d + 0.5);
                Granule.is_table_lsf[i][n4][n] = 0x800000;
            }
        }
        csa_table = new int[16];
        for (n = 0; n < 8; ++n) {
            double d = ci_table[n];
            double d2 = 1.0 / Granule.sqrt(1.0 + d * d);
            double d3 = d2 * d;
            Granule.csa_table[n * 2] = (int)(d2 * 8388608.0);
            Granule.csa_table[n * 2 + 1] = (int)(d3 * 8388608.0);
        }
    }
}

