/*
 * Decompiled with CFR 0.152.
 */
package railo.cli.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import railo.cli.util.EnumerationWrapper;

public class ServletContextImpl
implements ServletContext {
    private Map<String, Object> attributes;
    private Map<String, String> parameters;
    private int majorVersion;
    private int minorVersion;
    private File root;

    public ServletContextImpl(File root, Map<String, Object> attributes, Map<String, String> parameters, int majorVersion, int minorVersion) {
        this.root = root;
        this.attributes = attributes;
        this.parameters = parameters;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationWrapper(this.attributes);
    }

    public String getInitParameter(String key) {
        return this.parameters.get(key);
    }

    public Enumeration getInitParameterNames() {
        return new EnumerationWrapper(this.parameters);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getMimeType(String file) {
        throw this.notSupported("getMimeType(String file)");
    }

    public String getRealPath(String realpath) {
        return this.getRealFile(realpath).getAbsolutePath();
    }

    public URL getResource(String realpath) throws MalformedURLException {
        File file = this.getRealFile(realpath);
        return file.toURL();
    }

    public InputStream getResourceAsStream(String realpath) {
        try {
            return new FileInputStream(this.getRealFile(realpath));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public File getRealFile(String realpath) {
        return new File(this.root, realpath);
    }

    public File getRoot() {
        return this.root;
    }

    public Set getResourcePaths(String realpath) {
        throw this.notSupported("getResourcePaths(String realpath)");
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw this.notSupported("getNamedDispatcher(String name)");
    }

    public ServletContext getContext(String key) {
        return this;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw this.notSupported("getNamedDispatcher(String name)");
    }

    public void log(String msg, Throwable t) {
        if (t == null) {
            System.out.println(msg);
        } else {
            System.out.println(String.valueOf(msg) + ":\n" + t.getMessage());
        }
    }

    public void log(Exception e, String msg) {
        this.log(msg, e);
    }

    public void log(String msg) {
        this.log(msg, null);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public String getServletContextName() {
        return null;
    }

    public String getServerInfo() {
        throw this.notSupported("getServlet()");
    }

    public Servlet getServlet(String arg0) throws ServletException {
        throw this.notSupported("getServlet()");
    }

    public Enumeration getServletNames() {
        throw this.notSupported("getServlet()");
    }

    public Enumeration getServlets() {
        throw this.notSupported("getServlet()");
    }

    private RuntimeException notSupported(String method) {
        throw new RuntimeException((Throwable)new ServletException("method " + method + " not supported"));
    }
}

