/*
 * Decompiled with CFR 0.152.
 */
package com.projity.timescale;

import com.projity.configuration.Configuration;
import com.projity.timescale.TimeScale;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.digester.Digester;

public class TimeScaleManager {
    protected int currentScaleIndex = -1;
    protected List scales = new LinkedList();
    protected int defaultIndex;
    protected boolean normalWidth = true;

    public void addTimeScale(TimeScale timeScale) {
        this.scales.add(timeScale);
    }

    public TimeScale getScale() {
        return (TimeScale)this.scales.get(this.getCurrentScaleIndex());
    }

    public int getMinWidth() {
        return this.getScale().getMinWidth();
    }

    public int getDefaultIndex() {
        return this.defaultIndex;
    }

    public void setDefaultIndex(int n) {
        this.defaultIndex = n;
    }

    public int getCurrentScaleIndex() {
        if (this.currentScaleIndex == -1) {
            this.currentScaleIndex = this.defaultIndex;
        }
        return this.currentScaleIndex;
    }

    public boolean toggleMinWidth(boolean bl) {
        if (bl != this.normalWidth) {
            this.normalWidth = bl;
            for (TimeScale timeScale : this.scales) {
                timeScale.toggleWidth(bl);
            }
            return true;
        }
        return false;
    }

    public boolean isShowWholeDays() {
        return this.getCurrentScaleIndex() <= 2;
    }

    public boolean canZoomIn() {
        return this.getCurrentScaleIndex() > 0;
    }

    public boolean canZoomOut() {
        return this.getCurrentScaleIndex() < this.scales.size() - 1;
    }

    public boolean zoomIn() {
        if (this.getCurrentScaleIndex() > 0) {
            --this.currentScaleIndex;
            return true;
        }
        return false;
    }

    public boolean zoomOut() {
        if (this.getCurrentScaleIndex() < this.scales.size() - 1) {
            ++this.currentScaleIndex;
            return true;
        }
        return false;
    }

    public boolean zoomReset() {
        if (this.currentScaleIndex != this.defaultIndex) {
            this.currentScaleIndex = this.defaultIndex;
            return true;
        }
        return false;
    }

    public static TimeScaleManager createInstance() {
        TimeScaleManager timeScaleManager = new TimeScaleManager();
        TimeScaleManager timeScaleManager2 = Configuration.getInstance().getTimeScales();
        timeScaleManager.defaultIndex = timeScaleManager2.defaultIndex;
        timeScaleManager.currentScaleIndex = timeScaleManager2.currentScaleIndex;
        Iterator iterator = timeScaleManager2.scales.iterator();
        while (iterator.hasNext()) {
            timeScaleManager.scales.add(((TimeScale)iterator.next()).clone());
        }
        return timeScaleManager;
    }

    public static void addDigesterEvents(Digester digester) {
        digester.addObjectCreate("*/timescales", "com.projity.timescale.TimeScaleManager");
        digester.addSetProperties("*/timescales");
        digester.addSetNext("*/timescales", "setTimeScales", "com.projity.timescale.TimeScaleManager");
        digester.addObjectCreate("*/timescales/timescale", "com.projity.timescale.TimeScale");
        digester.addSetProperties("*/timescales/timescale");
        digester.addSetNext("*/timescales/timescale", "addTimeScale", "com.projity.timescale.TimeScale");
    }

    public final void setCurrentScaleIndex(int n) {
        this.currentScaleIndex = n;
    }
}

