/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.renderer;

import com.projity.graphic.configuration.CellFormat;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;

public class FontManager {
    public static final Font SVG_DEFAULT_FONT = new Font("SansSerif", 0, 12);
    public static final Font DEFAULT_FONT = UIManager.getFont("Table.font");
    public static Map boldMapping = new HashMap();
    public static Map italicMapping = new HashMap();
    public static Map boldItalicMapping = new HashMap();
    protected static Font offlineDefaultFont;

    public static void setComponentFont(CellFormat cellFormat, Component component) {
        Font font = component.getFont();
        if (offlineDefaultFont != null) {
            component.setFont(offlineDefaultFont);
        }
        if (cellFormat.isBold() || cellFormat.isItalic()) {
            int n;
            Map map;
            if (cellFormat.isBold() && !cellFormat.isItalic()) {
                map = boldMapping;
                n = 1;
            } else if (!cellFormat.isBold() && cellFormat.isItalic()) {
                map = italicMapping;
                n = 2;
            } else {
                map = boldItalicMapping;
                n = 3;
            }
            Font font2 = (Font)map.get(font);
            if (font2 == null) {
                font2 = font.deriveFont(n);
                map.put(font, font2);
            }
            component.setFont(font2);
        }
    }

    public static void setOfflineDefaultFont(Font font) {
        offlineDefaultFont = font;
    }

    public static Font getOfflineDefaultFont() {
        return offlineDefaultFont;
    }
}

