/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment.timesheet;

import com.projity.pm.assignment.timesheet.UpdatesFromTimesheet;
import com.projity.strings.Messages;
import java.util.Collection;
import java.util.Iterator;

public class TimesheetHelper {
    public static boolean applyTimesheet(Collection collection, Collection collection2, long l) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!((UpdatesFromTimesheet)iterator.next()).applyTimesheet(collection2, l)) continue;
            bl = true;
        }
        return bl;
    }

    public static long getLastTimesheetUpdate(Collection collection) {
        long l = 0L;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            l = Math.max(l, ((UpdatesFromTimesheet)iterator.next()).getLastTimesheetUpdate());
        }
        return l;
    }

    public static boolean isPendingTimesheetUpdate(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!((UpdatesFromTimesheet)iterator.next()).isPendingTimesheetUpdate()) continue;
            return true;
        }
        return false;
    }

    public static int getTimesheetStatus(Collection collection) {
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int n2 = ((UpdatesFromTimesheet)iterator.next()).getTimesheetStatus();
            if (n2 == 0) continue;
            if (n == 0) {
                n = n2;
                continue;
            }
            return -1;
        }
        return n;
    }

    public static String getTimesheetStatusName(int n) {
        return Messages.getString(TimesheetHelper.getTimesheetStatusStyle(n));
    }

    public static String getTimesheetStatusStyle(int n) {
        switch (n) {
            case 1: {
                return "timesheetEntered";
            }
            case 3: {
                return "timesheetIntegrated";
            }
            case 0: {
                return "timesheetNoData";
            }
            case 4: {
                return "timesheetRejected";
            }
            case 2: {
                return "timesheetValidated";
            }
            case -1: {
                return "timesheetMixed";
            }
        }
        return "timesheetNoData";
    }

    public static String getStatusName(int n) {
        switch (n) {
            case 1: {
                return Messages.getString("TimesheetHelper.Entered");
            }
            case 3: {
                return Messages.getString("TimesheetHelper.Integrated");
            }
            case 0: {
                return Messages.getString("TimesheetHelper.New");
            }
            case 4: {
                return Messages.getString("TimesheetHelper.Rejected");
            }
            case 2: {
                return Messages.getString("TimesheetHelper.Validated");
            }
            case -1: {
                return Messages.getString("TimesheetHelper.Mixed");
            }
            case 5: {
                return Messages.getString("TimesheetHelper.Saved");
            }
        }
        return Messages.getString("TimesheetHelper.New");
    }

    public static boolean isReadOnly(int n) {
        return n == 1 || n == 3 || n == 2;
    }
}

