/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.builder;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

public abstract class ToStringStyle
implements Serializable {
    public static final ToStringStyle DEFAULT_STYLE;
    public static final ToStringStyle MULTI_LINE_STYLE;
    public static final ToStringStyle NO_FIELD_NAMES_STYLE;
    public static final ToStringStyle SHORT_PREFIX_STYLE;
    public static final ToStringStyle SIMPLE_STYLE;
    private boolean useFieldNames = true;
    private boolean useClassName = true;
    private boolean useShortClassName = false;
    private boolean useIdentityHashCode = true;
    private String contentStart = "[";
    private String contentEnd = "]";
    private String fieldNameValueSeparator = "=";
    private boolean fieldSeparatorAtStart = false;
    private boolean fieldSeparatorAtEnd = false;
    private String fieldSeparator = ",";
    private String arrayStart = "{";
    private String arraySeparator = ",";
    private boolean arrayContentDetail = true;
    private String arrayEnd = "}";
    private boolean defaultFullDetail = true;
    private String nullText = "<null>";
    private String sizeStartText = "<size=";
    private String sizeEndText = ">";
    private String summaryObjectStartText = "<";
    private String summaryObjectEndText = ">";

    static {
        class Org_apache_commons_lang_builder_ToStringStyle$1 {
        }
        DEFAULT_STYLE = new DefaultToStringStyle();
        MULTI_LINE_STYLE = new MultiLineToStringStyle();
        NO_FIELD_NAMES_STYLE = new NoFieldNameToStringStyle();
        SHORT_PREFIX_STYLE = new ShortPrefixToStringStyle();
        SIMPLE_STYLE = new SimpleToStringStyle();
    }

    protected ToStringStyle() {
    }

    public void append(StringBuffer buffer, String fieldName, Object value, Boolean fullDetail) {
        this.appendFieldStart(buffer, fieldName);
        if (value == null) {
            this.appendNullText(buffer, fieldName);
        } else {
            this.appendInternal(buffer, fieldName, value, this.isFullDetail(fullDetail));
        }
        this.appendFieldEnd(buffer, fieldName);
    }

    protected void appendClassName(StringBuffer buffer, Object object) {
        if (this.useClassName && object != null) {
            if (this.useShortClassName) {
                buffer.append(this.getShortClassName(object.getClass()));
            } else {
                buffer.append(object.getClass().getName());
            }
        }
    }

    protected void appendContentEnd(StringBuffer buffer) {
        buffer.append(this.contentEnd);
    }

    protected void appendContentStart(StringBuffer buffer) {
        buffer.append(this.contentStart);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, byte value) {
        buffer.append(value);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, char value) {
        buffer.append(value);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, double value) {
        buffer.append(value);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, float value) {
        buffer.append(value);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, int value) {
        buffer.append(value);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, long value) {
        buffer.append(value);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
        buffer.append(value);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Collection coll) {
        buffer.append(coll);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Map map) {
        buffer.append(map);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, short value) {
        buffer.append(value);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, boolean value) {
        buffer.append(value);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, byte[] array) {
        buffer.append(this.arrayStart);
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
            ++i;
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, char[] array) {
        buffer.append(this.arrayStart);
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
            ++i;
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, double[] array) {
        buffer.append(this.arrayStart);
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
            ++i;
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, float[] array) {
        buffer.append(this.arrayStart);
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
            ++i;
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, int[] array) {
        buffer.append(this.arrayStart);
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
            ++i;
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, long[] array) {
        buffer.append(this.arrayStart);
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
            ++i;
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Object[] array) {
        buffer.append(this.arrayStart);
        int i = 0;
        while (i < array.length) {
            Object item = array[i];
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            if (item == null) {
                this.appendNullText(buffer, fieldName);
            } else {
                this.appendInternal(buffer, fieldName, item, this.arrayContentDetail);
            }
            ++i;
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, short[] array) {
        buffer.append(this.arrayStart);
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
            ++i;
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, boolean[] array) {
        buffer.append(this.arrayStart);
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array[i]);
            ++i;
        }
        buffer.append(this.arrayEnd);
    }

    public void appendEnd(StringBuffer buffer, Object object) {
        if (!this.fieldSeparatorAtEnd) {
            this.removeLastFieldSeparator(buffer);
        }
        this.appendContentEnd(buffer);
    }

    protected void appendFieldEnd(StringBuffer buffer, String fieldName) {
        this.appendFieldSeparator(buffer);
    }

    protected void appendFieldSeparator(StringBuffer buffer) {
        buffer.append(this.fieldSeparator);
    }

    protected void appendFieldStart(StringBuffer buffer, String fieldName) {
        if (this.useFieldNames && fieldName != null) {
            buffer.append(fieldName);
            buffer.append(this.fieldNameValueSeparator);
        }
    }

    protected void appendIdentityHashCode(StringBuffer buffer, Object object) {
        if (this.isUseIdentityHashCode() && object != null) {
            buffer.append('@');
            buffer.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    protected void appendInternal(StringBuffer buffer, String fieldName, Object value, boolean detail) {
        if (ReflectionToStringBuilder.isRegistered(value) && !(value instanceof Number) && !(value instanceof Boolean) && !(value instanceof Character)) {
            ObjectUtils.appendIdentityToString(buffer, value);
        } else if (value instanceof Collection) {
            if (detail) {
                this.appendDetail(buffer, fieldName, (Collection)value);
            } else {
                this.appendSummarySize(buffer, fieldName, ((Collection)value).size());
            }
        } else if (value instanceof Map) {
            if (detail) {
                this.appendDetail(buffer, fieldName, (Map)value);
            } else {
                this.appendSummarySize(buffer, fieldName, ((Map)value).size());
            }
        } else if (value instanceof long[]) {
            if (detail) {
                this.appendDetail(buffer, fieldName, (long[])value);
            } else {
                this.appendSummary(buffer, fieldName, (long[])value);
            }
        } else if (value instanceof int[]) {
            if (detail) {
                this.appendDetail(buffer, fieldName, (int[])value);
            } else {
                this.appendSummary(buffer, fieldName, (int[])value);
            }
        } else if (value instanceof short[]) {
            if (detail) {
                this.appendDetail(buffer, fieldName, (short[])value);
            } else {
                this.appendSummary(buffer, fieldName, (short[])value);
            }
        } else if (value instanceof byte[]) {
            if (detail) {
                this.appendDetail(buffer, fieldName, (byte[])value);
            } else {
                this.appendSummary(buffer, fieldName, (byte[])value);
            }
        } else if (value instanceof char[]) {
            if (detail) {
                this.appendDetail(buffer, fieldName, (char[])value);
            } else {
                this.appendSummary(buffer, fieldName, (char[])value);
            }
        } else if (value instanceof double[]) {
            if (detail) {
                this.appendDetail(buffer, fieldName, (double[])value);
            } else {
                this.appendSummary(buffer, fieldName, (double[])value);
            }
        } else if (value instanceof float[]) {
            if (detail) {
                this.appendDetail(buffer, fieldName, (float[])value);
            } else {
                this.appendSummary(buffer, fieldName, (float[])value);
            }
        } else if (value instanceof boolean[]) {
            if (detail) {
                this.appendDetail(buffer, fieldName, (boolean[])value);
            } else {
                this.appendSummary(buffer, fieldName, (boolean[])value);
            }
        } else if (value.getClass().isArray()) {
            if (detail) {
                this.appendDetail(buffer, fieldName, (Object[])value);
            } else {
                this.appendSummary(buffer, fieldName, (Object[])value);
            }
        } else if (detail) {
            this.appendDetail(buffer, fieldName, value);
        } else {
            this.appendSummary(buffer, fieldName, value);
        }
    }

    protected void appendNullText(StringBuffer buffer, String fieldName) {
        buffer.append(this.nullText);
    }

    public void appendStart(StringBuffer buffer, Object object) {
        if (object != null) {
            this.appendClassName(buffer, object);
            this.appendIdentityHashCode(buffer, object);
            this.appendContentStart(buffer);
            if (this.fieldSeparatorAtStart) {
                this.appendFieldSeparator(buffer);
            }
        }
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, Object value) {
        buffer.append(this.summaryObjectStartText);
        buffer.append(this.getShortClassName(value.getClass()));
        buffer.append(this.summaryObjectEndText);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, byte[] array) {
        this.appendSummarySize(buffer, fieldName, array.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, char[] array) {
        this.appendSummarySize(buffer, fieldName, array.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, double[] array) {
        this.appendSummarySize(buffer, fieldName, array.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, float[] array) {
        this.appendSummarySize(buffer, fieldName, array.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, int[] array) {
        this.appendSummarySize(buffer, fieldName, array.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, long[] array) {
        this.appendSummarySize(buffer, fieldName, array.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, Object[] array) {
        this.appendSummarySize(buffer, fieldName, array.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, short[] array) {
        this.appendSummarySize(buffer, fieldName, array.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, boolean[] array) {
        this.appendSummarySize(buffer, fieldName, array.length);
    }

    protected void appendSummarySize(StringBuffer buffer, String fieldName, int size) {
        buffer.append(this.sizeStartText);
        buffer.append(size);
        buffer.append(this.sizeEndText);
    }

    protected String getNullText() {
        return this.nullText;
    }

    protected String getShortClassName(Class cls) {
        return ClassUtils.getShortClassName(cls);
    }

    protected boolean isFullDetail(Boolean fullDetailRequest) {
        if (fullDetailRequest == null) {
            return this.defaultFullDetail;
        }
        return fullDetailRequest;
    }

    protected boolean isUseIdentityHashCode() {
        return this.useIdentityHashCode;
    }

    protected void reflectionAppendArrayDetail(StringBuffer buffer, String fieldName, Object array) {
        buffer.append(this.arrayStart);
        int length = Array.getLength(array);
        int i = 0;
        while (i < length) {
            Object item = Array.get(array, i);
            if (i > 0) {
                buffer.append(this.arraySeparator);
            }
            if (item == null) {
                this.appendNullText(buffer, fieldName);
            } else {
                this.appendInternal(buffer, fieldName, item, this.arrayContentDetail);
            }
            ++i;
        }
        buffer.append(this.arrayEnd);
    }

    protected void removeLastFieldSeparator(StringBuffer buffer) {
        int len = buffer.length();
        int sepLen = this.fieldSeparator.length();
        if (len > 0 && sepLen > 0 && len >= sepLen) {
            boolean match = true;
            int i = 0;
            while (i < sepLen) {
                if (buffer.charAt(len - 1 - i) != this.fieldSeparator.charAt(sepLen - 1 - i)) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (match) {
                buffer.setLength(len - sepLen);
            }
        }
    }

    protected void setContentEnd(String contentEnd) {
        if (contentEnd == null) {
            contentEnd = "";
        }
        this.contentEnd = contentEnd;
    }

    protected void setContentStart(String contentStart) {
        if (contentStart == null) {
            contentStart = "";
        }
        this.contentStart = contentStart;
    }

    protected void setFieldSeparator(String fieldSeparator) {
        if (fieldSeparator == null) {
            fieldSeparator = "";
        }
        this.fieldSeparator = fieldSeparator;
    }

    protected void setFieldSeparatorAtStart(boolean fieldSeparatorAtStart) {
        this.fieldSeparatorAtStart = fieldSeparatorAtStart;
    }

    protected void setUseClassName(boolean useClassName) {
        this.useClassName = useClassName;
    }

    protected void setUseFieldNames(boolean useFieldNames) {
        this.useFieldNames = useFieldNames;
    }

    protected void setUseIdentityHashCode(boolean useIdentityHashCode) {
        this.useIdentityHashCode = useIdentityHashCode;
    }

    protected void setUseShortClassName(boolean useShortClassName) {
        this.useShortClassName = useShortClassName;
    }

    private static final class DefaultToStringStyle
    extends ToStringStyle {
        private DefaultToStringStyle() {
        }
    }

    private static final class NoFieldNameToStringStyle
    extends ToStringStyle {
        private NoFieldNameToStringStyle() {
            this.setUseFieldNames(false);
        }
    }

    private static final class ShortPrefixToStringStyle
    extends ToStringStyle {
        private ShortPrefixToStringStyle() {
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
        }
    }

    private static final class SimpleToStringStyle
    extends ToStringStyle {
        private SimpleToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setUseFieldNames(false);
            this.setContentStart("");
            this.setContentEnd("");
        }
    }

    private static final class MultiLineToStringStyle
    extends ToStringStyle {
        private MultiLineToStringStyle() {
            this.setContentStart("[");
            this.setFieldSeparator(String.valueOf(SystemUtils.LINE_SEPARATOR) + "  ");
            this.setFieldSeparatorAtStart(true);
            this.setContentEnd(String.valueOf(SystemUtils.LINE_SEPARATOR) + "]");
        }
    }
}

