/*
 * Decompiled with CFR 0.152.
 */
package antlr.collections.impl;

public class BitSet
implements Cloneable {
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] lArray) {
        this.bits = lArray;
    }

    public BitSet(int n) {
        this.bits = new long[(n - 1 >> 6) + 1];
    }

    private static final long bitMask(int n) {
        int n2 = n & 0x3F;
        return 1L << n2;
    }

    public Object clone() {
        BitSet bitSet;
        try {
            bitSet = (BitSet)super.clone();
            bitSet.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, bitSet.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return bitSet;
    }

    public int degree() {
        int n = 0;
        for (int i = this.bits.length - 1; i >= 0; --i) {
            long l = this.bits[i];
            if (l == 0L) continue;
            for (int j = 63; j >= 0; --j) {
                if ((l & 1L << j) == 0L) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BitSet) {
            int n;
            BitSet bitSet = (BitSet)object;
            int n2 = n = Math.min(this.bits.length, bitSet.bits.length);
            while (n2-- > 0) {
                if (this.bits[n2] == bitSet.bits[n2]) continue;
                return false;
            }
            if (this.bits.length > n) {
                n2 = this.bits.length;
                while (n2-- > n) {
                    if (this.bits[n2] == 0L) continue;
                    return false;
                }
            } else if (bitSet.bits.length > n) {
                n2 = bitSet.bits.length;
                while (n2-- > n) {
                    if (bitSet.bits[n2] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean member(int n) {
        int n2 = BitSet.wordNumber(n);
        if (n2 >= this.bits.length) {
            return false;
        }
        return (this.bits[n2] & BitSet.bitMask(n)) != 0L;
    }

    public int[] toArray() {
        int[] nArray = new int[this.degree()];
        int n = 0;
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String string) {
        String string2 = "";
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            if (string2.length() > 0) {
                string2 = string2 + string;
            }
            string2 = string2 + i;
        }
        return string2;
    }

    private static final int wordNumber(int n) {
        return n >> 6;
    }
}

