/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;

final class BreakpointLineUpdater
implements PropertyChangeListener {
    private final RubyLineBreakpoint breakpoint;
    private DataObject dataObject;
    private Line line;

    public BreakpointLineUpdater(RubyLineBreakpoint breakpoint) {
        this.breakpoint = breakpoint;
        try {
            this.dataObject = DataObject.find((FileObject)breakpoint.getFileObject());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public synchronized void attach() throws IOException {
        this.breakpoint.addPropertyChangeListener(this);
        try {
            LineCookie lc = (LineCookie)this.dataObject.getCookie(LineCookie.class);
            this.line = lc.getLineSet().getCurrent(this.breakpoint.getLineNumber() - 1);
            this.line.addPropertyChangeListener((PropertyChangeListener)this);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public synchronized void detach() {
        this.breakpoint.removePropertyChangeListener(this);
        if (this.line != null) {
            this.line.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if ("lineNumber".equals(evt.getPropertyName()) && this.line == evt.getSource()) {
            this.breakpoint.notifyUpdated();
            return;
        }
    }
}

