/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.RubyDebuggerEngineProvider;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;

public final class RubyDebuggerActionProvider
extends ActionsProviderSupport
implements RubyDebugEventListener {
    public static final Logger LOGGER = Logger.getLogger(RubyDebuggerActionProvider.class.getName());
    private static final Set<Object> ACTIONS;
    private final Semaphore frontEndSemaphore;
    private final Semaphore backEndSemaphore;
    private final ContextProviderWrapper contextProvider;
    private final RubyDebuggerEngineProvider engineProvider;
    private final RubySession rubySession;
    private Boolean terminated;

    public RubyDebuggerActionProvider(ContextProvider contextProvider) {
        this.engineProvider = (RubyDebuggerEngineProvider)((Object)contextProvider.lookupFirst(null, DebuggerEngineProvider.class));
        this.contextProvider = new ContextProviderWrapper(contextProvider);
        this.rubySession = this.contextProvider.getRubySession();
        this.frontEndSemaphore = new Semaphore(1, true);
        this.backEndSemaphore = new Semaphore(1, true);
        this.terminated = false;
        boolean acquired = this.frontEndSemaphore.tryAcquire();
        assert (acquired);
        for (Object action : ACTIONS) {
            this.setEnabled(action, true);
        }
    }

    public Set<Object> getActions() {
        return ACTIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(Object action) {
        LOGGER.finer("Performing \"" + action + '\"');
        if (action == ActionsManager.ACTION_KILL) {
            this.finish(true);
            return;
        }
        if (this.frontEndSemaphore.getQueueLength() > 10) {
            LOGGER.info("Too much pending events (> 10). Action \"" + action + "\" is rejected.");
            return;
        }
        try {
            this.frontEndSemaphore.acquire();
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return;
        }
        Boolean bl = this.terminated;
        synchronized (bl) {
            if (this.terminated.booleanValue()) {
                LOGGER.info("Flushing cached actions: " + action + ", process is terminated.");
                this.frontEndSemaphore.release();
                return;
            }
        }
        if (action == ActionsManager.ACTION_CONTINUE) {
            this.rubySession.resume();
            this.contextProvider.fireModelChanges();
        } else if (action == ActionsManager.ACTION_STEP_INTO) {
            this.rubySession.stepInto();
        } else if (action == ActionsManager.ACTION_RUN_TO_CURSOR) {
            this.rubySession.runToCursor();
        } else if (action == ActionsManager.ACTION_STEP_OUT) {
            if (this.rubySession.getFrames().length == 1) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(RubyDebuggerActionProvider.class, (String)"RubyDebuggerActionProvider.stepout.outermost.frame"));
                this.frontEndSemaphore.release();
                return;
            }
            this.rubySession.stepReturn();
        } else if (action == ActionsManager.ACTION_STEP_OVER) {
            this.rubySession.stepOver();
        }
        ContextProviderWrapper.getSessionsModel().fireChanges();
        this.backEndSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void onDebugEvent(RubyDebugEvent event) {
        if (event.isTerminateType()) {
            this.finish(false);
            return;
        }
        try {
            this.backEndSemaphore.acquire();
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return;
        }
        Boolean e = this.terminated;
        // MONITORENTER : e
        if (this.terminated.booleanValue()) {
            LOGGER.info("Flushing pending event: " + event + ", process is terminated.");
            this.backEndSemaphore.release();
            // MONITOREXIT : e
            return;
        }
        // MONITOREXIT : e
        if (event.isSuspensionType() || event.isExceptionType()) {
            String path = event.getFilePath();
            if ("(eval)".equals(path)) {
                this.rubySession.stepOver(true);
                ContextProviderWrapper.getSessionsModel().fireChanges();
                this.backEndSemaphore.release();
                return;
            }
            String absPath = this.rubySession.resolveAbsolutePath(path);
            if (absPath != null) {
                boolean shouldStop;
                File file = new File(absPath);
                FileObject fo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                boolean bl = shouldStop = event.isExceptionType() || event.isStepping() || this.rubySession.isRunningTo(file, event.getLine()) || fo != null && RubyBreakpointManager.isBreakpointOnLine(fo, event.getLine());
                if (!shouldStop) {
                    event.getRubyThread().resume();
                    this.backEndSemaphore.release();
                    return;
                }
                this.stopHere(event);
            } else {
                try {
                    event.getRubyThread().stepReturn();
                    this.backEndSemaphore.release();
                    return;
                }
                catch (RubyDebuggerException e2) {
                    LOGGER.log(Level.SEVERE, e2.getLocalizedMessage(), e2);
                }
            }
        } else assert (false) : "Unkown event type: " + event;
        this.frontEndSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean terminate) {
        Boolean bl = this.terminated;
        synchronized (bl) {
            LOGGER.finer("Finishing session: " + this.rubySession.getName());
            if (this.terminated.booleanValue()) {
                LOGGER.warning("Finish is not supposed to be called when a process is already terminated");
                return;
            }
            this.terminated = true;
        }
        this.rubySession.finish(this, terminate);
        EditorUtil.unmarkCurrent();
        this.engineProvider.getDestructor().killEngine();
        this.frontEndSemaphore.release();
        this.backEndSemaphore.release();
    }

    private void stopHere(RubyDebugEvent suspensionEvent) {
        this.rubySession.suspend(suspensionEvent.getRubyThread(), this.contextProvider);
        this.setEnabled(ActionsManager.ACTION_STEP_OUT, this.rubySession.getFrames().length != 1);
    }

    static {
        HashSet<Object> s = new HashSet<Object>();
        s.add(ActionsManager.ACTION_KILL);
        s.add(ActionsManager.ACTION_CONTINUE);
        s.add(ActionsManager.ACTION_STEP_INTO);
        s.add(ActionsManager.ACTION_STEP_OVER);
        s.add(ActionsManager.ACTION_STEP_OUT);
        s.add(ActionsManager.ACTION_RUN_TO_CURSOR);
        ACTIONS = Collections.unmodifiableSet(s);
    }
}

