/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.validation.constraints;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.j2ee.sun.validation.constraints.Constraint;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintFailure;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintUtils;
import org.netbeans.modules.j2ee.sun.validation.util.BundleReader;

public class InConstraint
extends ConstraintUtils
implements Constraint {
    private Collection enumeration = null;

    public InConstraint() {
        this.enumeration = new ArrayList();
    }

    public InConstraint(Collection enumeration) {
        this.enumeration = enumeration;
    }

    public InConstraint(String[] enumeration) {
        this.enumeration = new ArrayList();
        int size = enumeration.length;
        for (int i = 0; i < size; ++i) {
            this.enumeration.add(enumeration[i]);
        }
    }

    @Override
    public Collection match(String value, String name) {
        ArrayList<ConstraintFailure> failed_constrained_list = new ArrayList<ConstraintFailure>();
        if (value != null && value.length() != 0 && !this.enumeration.contains(value)) {
            String failureMessage = this.formatFailureMessage(this.toString(), value, name);
            String format = BundleReader.getValue("MSG_InConstraint_Failure");
            StringBuilder setBuilder = new StringBuilder(128);
            Iterator iterator = this.enumeration.iterator();
            while (iterator.hasNext()) {
                setBuilder.append(' ');
                setBuilder.append((String)iterator.next());
            }
            Object[] arguments = new Object[]{setBuilder.toString()};
            String genericFailureMessage = MessageFormat.format(format, arguments);
            failed_constrained_list.add(new ConstraintFailure(this.toString(), value, name, failureMessage, genericFailureMessage));
        }
        return failed_constrained_list;
    }

    public void setEnumerationValue(Collection enumeration) {
        this.enumeration = enumeration;
    }

    public void setEnumerationValue(String value) {
        this.enumeration.add(value);
    }

    @Override
    void print() {
        super.print();
        String format = BundleReader.getValue("Name_Value_Pair_Format");
        Iterator iterator = this.enumeration.iterator();
        String values = null;
        if (iterator.hasNext()) {
            StringBuilder valuesBuilder = new StringBuilder(128);
            while (iterator.hasNext()) {
                valuesBuilder.append("  ");
                valuesBuilder.append((String)iterator.next());
            }
            values = valuesBuilder.toString();
        }
        if (values != null) {
            Object[] arguments = new Object[]{"Enumeration Values", values};
            System.out.println(MessageFormat.format(format, arguments));
        }
    }
}

