/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.inspector.common;

import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorFolderPath;
import org.netbeans.modules.vmd.api.inspector.InspectorPositionController;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;

public final class FolderPositionControllerFactory {
    public static InspectorPositionController createHierarchical() {
        return new InspectorPositionController(){

            @Override
            public boolean isInside(InspectorFolderPath path, InspectorFolder folder, DesignComponent component) {
                if (path.getPath().isEmpty()) {
                    return false;
                }
                int parentIndex = path.getPath().size() - 1;
                if (path.getPath().get(parentIndex).getComponentID() != null && folder.getComponentID() != null) {
                    long parentComponentID = path.getPath().get(parentIndex).getComponentID();
                    DesignComponent parentComponent = component.getDocument().getComponentByUID(parentComponentID);
                    if (parentComponent.getType() != path.getLastElement().getTypeID()) {
                        return false;
                    }
                    for (DesignComponent childComponent : parentComponent.getComponents()) {
                        if (!folder.getComponentID().equals(childComponent.getComponentID())) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static InspectorPositionController createReference(final String propertyName) {
        return new InspectorPositionController(){

            @Override
            public boolean isInside(InspectorFolderPath path, InspectorFolder folder, DesignComponent component) {
                if (path.getPath().isEmpty()) {
                    return false;
                }
                int parentIndex = path.getPath().size() - 1;
                if (path.getPath().get(parentIndex).getComponentID() != null && folder.getComponentID() != null) {
                    DesignComponent referedComponent;
                    long parentComponentID = path.getPath().get(parentIndex).getComponentID();
                    DesignComponent parentComponent = component.getDocument().getComponentByUID(parentComponentID);
                    if (propertyName == null) {
                        for (PropertyDescriptor pd : parentComponent.getComponentDescriptor().getPropertyDescriptors()) {
                            DesignComponent referedComponent2;
                            if (pd.getType().getKind() != TypeID.Kind.COMPONENT || (referedComponent2 = parentComponent.readProperty(pd.getName()).getComponent()) == null || !folder.getComponentID().equals(referedComponent2.getComponentID())) continue;
                            return true;
                        }
                    } else if (parentComponent.getComponentDescriptor().getPropertyDescriptor(propertyName) != null && (referedComponent = parentComponent.readProperty(propertyName).getComponent()) != null && folder.getComponentID().equals(referedComponent.getComponentID())) {
                        return true;
                    }
                }
                return false;
            }
        };
    }
}

