/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class LMListener {
    private final MemoryMXBean memBean;
    private static final float DEFAULT_HEAP_LIMIT = 0.8f;
    private final float heapLimit;

    public LMListener() {
        this(0.8f);
    }

    public LMListener(float heapLimit) {
        this.heapLimit = heapLimit;
        this.memBean = ManagementFactory.getMemoryMXBean();
        assert (this.memBean != null);
    }

    public float getHeapLimit() {
        return this.heapLimit;
    }

    public boolean isLowMemory() {
        MemoryUsage usage;
        if (this.memBean != null && (usage = this.memBean.getHeapMemoryUsage()) != null) {
            long max;
            long used = usage.getUsed();
            return (float)used > (float)(max = usage.getMax()) * this.heapLimit;
        }
        return false;
    }
}

