/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.css.gsf.CssAnalyser;
import org.netbeans.modules.css.gsf.CssGSFParser;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class CssSemanticAnalyzer
extends SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        this.cancelled = false;
        if (this.cancelled) {
            return;
        }
        final HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        SimpleNode root = ((CssParserResult)result).root();
        final Snapshot snapshot = result.getSnapshot();
        if (root == null) {
            this.semanticHighlights = highlights;
            return;
        }
        NodeVisitor visitor = new NodeVisitor(){

            @Override
            public void visit(SimpleNode node) {
                if (node.kind() == 24 || node.kind() == 23 || node.kind() == 26 || node.kind() == 27 || node.kind() == 25) {
                    int dso = snapshot.getOriginalOffset(node.startOffset());
                    if (dso == -1) {
                        dso = snapshot.getOriginalOffset(node.startOffset() + 1);
                    }
                    int deo = snapshot.getOriginalOffset(node.endOffset());
                    if (dso >= 0 && deo >= 0) {
                        OffsetRange range = new OffsetRange(dso, deo);
                        highlights.put(range, ColoringAttributes.METHOD_SET);
                    }
                } else if (node.kind() == 18) {
                    int dso = snapshot.getOriginalOffset(node.startOffset());
                    int deo = snapshot.getOriginalOffset(node.endOffset());
                    if (dso >= 0 && deo >= 0) {
                        OffsetRange range = new OffsetRange(dso, deo);
                        String propertyName = node.image().trim();
                        if (CssGSFParser.containsGeneratedCode(propertyName)) {
                            return;
                        }
                        if (CssAnalyser.isVendorSpecificProperty(propertyName)) {
                            highlights.put(range, ColoringAttributes.CUSTOM2_SET);
                        } else {
                            highlights.put(range, ColoringAttributes.CUSTOM1_SET);
                        }
                    }
                }
            }
        };
        root.visitChildren(visitor);
        this.semanticHighlights = highlights;
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return null;
    }
}

