/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.spi;

import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.progress.spi.InternalHandle;

public final class TaskModel {
    private DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private DefaultListModel model = new DefaultListModel();
    private InternalHandle explicit;

    public void addHandle(InternalHandle handle) {
        this.model.addElement(handle);
        this.updateSelection();
    }

    public void removeHandle(InternalHandle handle) {
        if (this.explicit == handle) {
            this.explicit = null;
        }
        this.model.removeElement(handle);
        this.updateSelection();
    }

    void updateSelection() {
        if (this.explicit != null) {
            return;
        }
        InternalHandle oldSelected = this.getSelectedHandle();
        if (oldSelected != null && !oldSelected.isInSleepMode()) {
            return;
        }
        InternalHandle toSelect = null;
        for (int i = 0; i < this.model.size(); ++i) {
            InternalHandle curHandle = (InternalHandle)this.model.getElementAt(i);
            if (this.getSelectionRating(curHandle) < this.getSelectionRating(toSelect)) continue;
            toSelect = curHandle;
        }
        if (toSelect != null) {
            this.selectionModel.setSelectionInterval(this.model.indexOf(toSelect), this.model.indexOf(toSelect));
        } else {
            this.selectionModel.clearSelection();
        }
    }

    private int getSelectionRating(InternalHandle handle) {
        int result = 0;
        if (handle != null) {
            if (!handle.isInSleepMode()) {
                result += 4;
            }
            if (handle.isUserInitialized()) {
                result += 2;
            }
            ++result;
        }
        return result;
    }

    public void explicitlySelect(InternalHandle handle) {
        this.explicit = handle;
        int index = this.model.indexOf(this.explicit);
        if (index == -1) {
            // empty if block
        }
        this.selectionModel.setSelectionInterval(index, index);
    }

    public InternalHandle getExplicitSelection() {
        return this.explicit;
    }

    public int getSize() {
        return this.model.size();
    }

    public InternalHandle[] getHandles() {
        Object[] handles = new InternalHandle[this.model.size()];
        this.model.copyInto(handles);
        return handles;
    }

    public InternalHandle getSelectedHandle() {
        int select = this.selectionModel.getMinSelectionIndex();
        if (select != -1 && select >= 0 && select < this.model.size()) {
            return (InternalHandle)this.model.getElementAt(this.selectionModel.getMinSelectionIndex());
        }
        return null;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.selectionModel.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.selectionModel.removeListSelectionListener(listener);
    }

    public void addListDataListener(ListDataListener listener) {
        this.model.addListDataListener(listener);
    }

    public void removeListDataListener(ListDataListener listener) {
        this.model.removeListDataListener(listener);
    }
}

