/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.EditableProperties;
import org.openide.util.NbBundle;

public class RailsProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final RailsProject project;
    private static EditableProperties origPrivateProperties;

    public RailsProjectOperations(RailsProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, Set<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        RailsProjectOperations.addFile(projectDirectory, "nbproject", files);
        RailsProjectOperations.addFile(projectDirectory, "build.xml", files);
        RailsProjectOperations.addFile(projectDirectory, "xml-resources", files);
        RailsProjectOperations.addFile(projectDirectory, "catalog.xml", files);
        return new ArrayList<FileObject>(files);
    }

    public List<FileObject> getDataFiles() {
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        files.addAll(Arrays.asList(this.project.getSourceRoots().getRoots()));
        files.addAll(Arrays.asList(this.project.getTestSourceRoots().getRoots()));
        RailsProjectOperations.addFile(this.project.getProjectDirectory(), "app", files);
        RailsProjectOperations.addFile(this.project.getProjectDirectory(), "tmp", files);
        RailsProjectOperations.addFile(this.project.getProjectDirectory(), "test", files);
        RailsProjectOperations.addFile(this.project.getProjectDirectory(), "README", files);
        RailsProjectOperations.addFile(this.project.getProjectDirectory(), "Rakefile", files);
        RailsProjectOperations.addFile(this.project.getProjectDirectory(), "Capfile", files);
        return new ArrayList<FileObject>(files);
    }

    public void notifyDeleting() throws IOException {
        this.project.notifyDeleting();
    }

    public void notifyDeleted() throws IOException {
        this.project.getRakeProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        origPrivateProperties = this.project.getRakeProjectHelper().getProperties("nbproject/private/private.properties");
    }

    public void notifyCopied(Project original, File originalPath, String nueName) {
        if (original == null) {
            return;
        }
        this.project.getReferenceHelper().fixReferences(originalPath);
        this.project.setName(nueName);
        this.copyPrivateProps();
    }

    public void notifyMoving() throws IOException {
        origPrivateProperties = this.project.getRakeProjectHelper().getProperties("nbproject/private/private.properties");
        if (!this.project.getUpdateHelper().requestSave()) {
            throw new IOException(NbBundle.getMessage(RailsProjectOperations.class, (String)"MSG_OldProjectMetadata"));
        }
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, String nueName) {
        if (original == null) {
            this.project.getRakeProjectHelper().notifyDeleted();
            return;
        }
        this.project.setName(nueName);
        this.project.getReferenceHelper().fixReferences(originalPath);
        this.copyPrivateProps();
    }

    private void copyPrivateProps() {
        this.project.getReferenceHelper().copyToPrivateProperties(origPrivateProperties);
        origPrivateProperties = null;
    }
}

