/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.kenai.ui.dashboard.ColorManager;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.spi.LoginHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.treelist.LeafNode;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class UserNode
extends LeafNode {
    private final DashboardImpl dashboard;
    private JPanel panel;
    private JLabel lblUser;
    private TreeListNode.ProgressLabel lblProgress;
    private LinkButton btnOpenProject;
    private LinkButton btnRefresh;
    private LinkButton btnLogin;
    private LinkButton btnNewProject;
    private String progressTitle;
    private LoginHandle login;
    private boolean projectsAvailable = false;
    private final Object LOCK = new Object();
    private int loadingCounter = 0;

    public UserNode(DashboardImpl dashboard) {
        super(null);
        this.dashboard = dashboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JComponent getComponent(Color foreground, Color background, boolean isSelected, boolean hasFocus) {
        if (null == this.panel) {
            this.panel = new JPanel(new GridBagLayout());
            this.panel.setOpaque(false);
            this.btnLogin = new LinkButton(NbBundle.getMessage(UserNode.class, (String)"LBL_LoginToKenai"), this.dashboard.createLoginAction());
            this.lblUser = new TreeLabel();
            this.lblProgress = this.createProgressLabel(this.progressTitle);
            this.btnOpenProject = new LinkButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/open_kenai_project.png", (boolean)true), ProjectAccessor.getDefault().getOpenNonMemberProjectAction());
            this.btnOpenProject.setToolTipText(NbBundle.getMessage(UserNode.class, (String)"LBL_OpenProject"));
            this.btnNewProject = new LinkButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/new_kenai_project.png", (boolean)true), ProjectAccessor.getDefault().getNewKenaiProjectAction());
            this.btnNewProject.setToolTipText(NbBundle.getMessage(UserNode.class, (String)"LBL_NewKenaiProject"));
            this.btnRefresh = new LinkButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/ui/resources/refresh.png", (boolean)true), (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DashboardImpl.getInstance().refreshProjects();
                }
            });
            this.btnRefresh.setToolTipText(NbBundle.getMessage(UserNode.class, (String)"LBL_Refresh"));
            this.panel.add((Component)this.btnLogin, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
            this.panel.add((Component)this.lblUser, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.lblProgress, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.btnRefresh, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.btnNewProject, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 0), 0, 0));
            this.panel.add((Component)this.btnOpenProject, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 0), 0, 0));
        }
        this.lblProgress.setForeground(foreground);
        if (isSelected) {
            this.lblUser.setForeground(foreground);
        } else {
            this.lblUser.setForeground(ColorManager.getDefault().getDisabledColor());
        }
        this.btnOpenProject.setForeground(foreground, isSelected);
        this.btnRefresh.setForeground(foreground, isSelected);
        this.btnLogin.setForeground(foreground, isSelected);
        Object object = this.LOCK;
        synchronized (object) {
            this.lblProgress.setVisible(this.loadingCounter > 0);
            this.btnRefresh.setVisible(this.loadingCounter <= 0 && (this.projectsAvailable || null != this.login));
        }
        if (null != this.login) {
            this.lblUser.setText(this.login.getUserName());
        }
        this.btnLogin.setVisible(null == this.login);
        this.lblUser.setVisible(null != this.login);
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadingStarted(String title) {
        Object object = this.LOCK;
        synchronized (object) {
            this.progressTitle = title;
            if (this.lblProgress != null) {
                this.lblProgress.setText(title);
            }
            ++this.loadingCounter;
            this.fireContentChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadingFinished() {
        Object object = this.LOCK;
        synchronized (object) {
            --this.loadingCounter;
            if (this.loadingCounter < 0) {
                this.loadingCounter = 0;
            }
            if (this.loadingCounter == 0 && this.lblProgress != null) {
                this.lblProgress.stop();
            }
            this.fireContentChanged();
        }
    }

    void set(LoginHandle login, boolean projectsAvailable) {
        this.projectsAvailable = projectsAvailable;
        this.login = login;
        this.fireContentChanged();
    }
}

