/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.kenai.ui.dashboard.LinkButton;
import org.netbeans.modules.kenai.ui.spi.MessagingAccessor;
import org.netbeans.modules.kenai.ui.spi.MessagingHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectAccessor;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.treelist.AsynchronousLeafNode;
import org.netbeans.modules.kenai.ui.treelist.TreeLabel;
import org.netbeans.modules.kenai.ui.treelist.TreeListNode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class MessagingNode
extends AsynchronousLeafNode<MessagingHandle>
implements PropertyChangeListener {
    private final ProjectHandle project;
    private MessagingHandle messaging;
    private JPanel panel;
    private List<JLabel> labels = new ArrayList<JLabel>(5);
    private List<LinkButton> buttons = new ArrayList<LinkButton>(3);
    private final Object LOCK = new Object();

    public MessagingNode(TreeListNode parent, ProjectHandle project) {
        super(parent, null);
        this.project = project;
        this.messaging = this.load();
        this.messaging.addPropertyChangeListener(this);
        project.getKenaiProject().getKenai().addPropertyChangeListener("xmpp_login", (PropertyChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configure(JComponent component, Color foreground, Color background, boolean isSelected, boolean hasFocus) {
        if (this.panel == component) {
            Object object = this.LOCK;
            synchronized (object) {
                for (JLabel lbl : this.labels) {
                    lbl.setForeground(foreground);
                }
                for (LinkButton lb : this.buttons) {
                    lb.setForeground(foreground, isSelected);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JComponent createComponent(MessagingHandle data) {
        MessagingAccessor accessor = MessagingAccessor.getDefault();
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setOpaque(false);
        Object object = this.LOCK;
        synchronized (object) {
            this.labels.clear();
            this.buttons.clear();
            JLabel lbl = null;
            LinkButton btn = null;
            int onlineCount = this.messaging.getOnlineCount();
            if (onlineCount >= 0) {
                btn = new LinkButton(this.messaging.getMessageCount() + "", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/collab/resources/newmessage.png", (boolean)true), accessor.getOpenMessagesAction(this.project));
                btn.setHorizontalTextPosition(2);
                this.buttons.add(btn);
                this.panel.add((Component)btn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                lbl = new TreeLabel("|");
                this.labels.add(lbl);
                this.panel.add((Component)lbl, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            } else if (onlineCount == -2) {
                btn = new LinkButton(NbBundle.getMessage(MessagingNode.class, (String)"LBL_CreateChat", (Object)this.messaging.getMessageCount()), accessor.getCreateChatAction(this.project));
                this.buttons.add(btn);
                this.panel.add((Component)btn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                lbl = new TreeLabel("|");
                this.labels.add(lbl);
                this.panel.add((Component)lbl, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            } else if (onlineCount == -3) {
                lbl = new JLabel(NbBundle.getMessage(MessagingNode.class, (String)"LBL_ConnectionFailed"));
                lbl.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/ui/resources/error.png")));
                this.labels.add(lbl);
                this.panel.add((Component)lbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                lbl = new JLabel("(");
                this.labels.add(lbl);
                this.panel.add((Component)lbl, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
                btn = new LinkButton(NbBundle.getMessage(MessagingNode.class, (String)"LBL_Retry"), accessor.getReconnectAction(this.project));
                this.buttons.add(btn);
                this.panel.add((Component)btn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                lbl = new JLabel(")");
                this.labels.add(lbl);
                this.panel.add((Component)lbl, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                lbl = new JLabel("|");
                this.labels.add(lbl);
                this.panel.add((Component)lbl, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            }
            btn = new LinkButton(NbBundle.getMessage(MessagingNode.class, (String)"LBL_ProjectDetails"), ProjectAccessor.getDefault().getDetailsAction(this.project));
            this.buttons.add(btn);
            this.panel.add((Component)btn, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(8, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.panel;
    }

    @Override
    protected MessagingHandle load() {
        MessagingAccessor accessor = MessagingAccessor.getDefault();
        return accessor.getMessaging(this.project);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("xmpp_login".equals(evt.getPropertyName())) {
            if (evt.getOldValue() == null) {
                this.refresh();
            } else if (evt.getNewValue() == null) {
                this.messaging.removePropertyChangeListener(this);
                this.messaging = this.load();
                this.messaging.addPropertyChangeListener(this);
                this.refresh();
            }
        } else {
            this.refresh();
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (null != this.messaging) {
            this.messaging.removePropertyChangeListener(this);
        }
        this.project.getKenaiProject().getKenai().removePropertyChangeListener((PropertyChangeListener)this);
    }
}

