/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.PasswordAuthentication;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.api.KenaiUser;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.collab.chat.WhoIsOnlineAction;
import org.netbeans.modules.kenai.ui.LogoutAction;
import org.netbeans.modules.kenai.ui.Utilities;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class PresenceIndicator {
    private static final ImageIcon ONLINE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/collab/resources/online.png", (boolean)true);
    private static final ImageIcon OFFLINE = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/kenai/collab/resources/offline.png", (boolean)true);
    private static PresenceIndicator instance;
    private JLabel label = new JLabel();
    private MouseL helper;
    private boolean inited = false;

    private void setStatus(Kenai.Status status) {
        this.label.setIcon(status == Kenai.Status.ONLINE ? ONLINE : OFFLINE);
        if (status != Kenai.Status.ONLINE) {
            this.label.setText("");
        }
        switch (status) {
            case OFFLINE: {
                this.label.setToolTipText(NbBundle.getMessage(PresenceIndicator.class, (String)"LBL_Offline_Tooltip"));
                break;
            }
            case LOGGED_IN: {
                this.label.setToolTipText(NbBundle.getMessage(PresenceIndicator.class, (String)"LBL_LoggedInButNotOnChat_Tooltip"));
                break;
            }
            case ONLINE: {
                this.label.setToolTipText(NbBundle.getMessage(PresenceIndicator.class, (String)"LBL_LoggedIn_Tooltip", (Object)(KenaiUser.getOnlineUserCount() > 0 ? Integer.valueOf(KenaiUser.getOnlineUserCount() - 1) : "")));
            }
        }
        this.label.setVisible(status != Kenai.Status.OFFLINE);
    }

    private static Kenai.Status getKenaiStatus() {
        Kenai.Status s = Kenai.Status.OFFLINE;
        for (Kenai k : KenaiManager.getDefault().getKenais()) {
            if (k.getStatus() == Kenai.Status.ONLINE) {
                return Kenai.Status.ONLINE;
            }
            if (k.getStatus() != Kenai.Status.LOGGED_IN) continue;
            s = Kenai.Status.LOGGED_IN;
        }
        return s;
    }

    Component getComponent() {
        return this.label;
    }

    public static synchronized PresenceIndicator getDefault() {
        if (instance == null) {
            instance = new PresenceIndicator();
        }
        return instance;
    }

    private PresenceIndicator() {
        this.label.setVisible(false);
        this.label.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.helper = new MouseL();
        this.label.addMouseListener(this.helper);
    }

    public synchronized void init() {
        if (this.inited) {
            return;
        }
        KenaiManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PresenceIndicator.this.setStatus(PresenceIndicator.getKenaiStatus());
            }
        });
        this.inited = true;
    }

    public static class PresenceListener
    implements PacketListener {
        public void processPacket(Packet packet) {
            PresenceIndicator.getDefault().label.setText(KenaiUser.getOnlineUserCount() > 0 ? KenaiUser.getOnlineUserCount() - 1 + "" : "");
            PresenceIndicator.getDefault().label.setToolTipText(NbBundle.getMessage(PresenceIndicator.class, (String)"LBL_LoggedIn_Tooltip", (Object)(KenaiUser.getOnlineUserCount() > 0 ? Integer.valueOf(KenaiUser.getOnlineUserCount() - 1) : "")));
            for (MultiUserChat muc : KenaiConnection.getDefault(KenaiConnection.getKenai(StringUtils.parseBareAddress((String)packet.getFrom()))).getChats()) {
                String chatName = StringUtils.parseName((String)muc.getRoom());
                assert (chatName != null) : "muc.getRoom() = " + muc.getRoom();
                ChatNotifications.getDefault().getMessagingHandle(KenaiConnection.getKenaiProject(muc)).setOnlineCount(muc.getOccupantsCount());
            }
        }
    }

    private class MouseL
    extends MouseAdapter {
        private Cursor oldCursor;

        private MouseL() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.oldCursor = PresenceIndicator.this.label.getCursor();
            PresenceIndicator.this.label.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PresenceIndicator.this.label.setCursor(this.oldCursor);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Kenai.Status s = PresenceIndicator.getKenaiStatus();
            if (event.getClickCount() == 2) {
                if (s == Kenai.Status.ONLINE) {
                    ChatTopComponent.openAction((TopComponent)ChatTopComponent.findInstance(), (String)"", (String)"", (boolean)false).actionPerformed(new ActionEvent(event, event.getID(), ""));
                }
            } else if (s != Kenai.Status.OFFLINE) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem contactListMenu = new JMenuItem(NbBundle.getMessage(PresenceIndicator.class, (String)"CTL_WhoIsOnlineAction"));
                menu.add(contactListMenu);
                contactListMenu.setEnabled(s == Kenai.Status.ONLINE);
                final JCheckBoxMenuItem onlineCheckBox = new JCheckBoxMenuItem(NbBundle.getMessage(PresenceIndicator.class, (String)"CTL_OnlineCheckboxMenuItem"), s == Kenai.Status.ONLINE);
                menu.add(onlineCheckBox);
                for (final Kenai k : KenaiManager.getDefault().getKenais()) {
                    if (k.getStatus() == Kenai.Status.OFFLINE) continue;
                    JMenu m = new JMenu(k.getName());
                    final JCheckBoxMenuItem onlineCheckBoxForKenai = new JCheckBoxMenuItem(NbBundle.getMessage(PresenceIndicator.class, (String)"CTL_OnlineCheckboxMenuItem"), k.getStatus() == Kenai.Status.ONLINE);
                    m.add(onlineCheckBoxForKenai);
                    JMenuItem logoutItem = new JMenuItem(NbBundle.getMessage(PresenceIndicator.class, (String)"CTL_LogoutMenuItem"));
                    m.add(logoutItem);
                    menu.add(m);
                    onlineCheckBoxForKenai.setEnabled(Utilities.isChatSupported(k));
                    onlineCheckBoxForKenai.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                PasswordAuthentication passwordAuthentication = k.getPasswordAuthentication();
                                if (passwordAuthentication != null) {
                                    k.login(passwordAuthentication.getUserName(), passwordAuthentication.getPassword(), onlineCheckBoxForKenai.isSelected());
                                }
                            }
                            catch (KenaiException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                    logoutItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    k.logout();
                                }
                            });
                        }
                    });
                }
                JMenuItem logoutItem = new JMenuItem(NbBundle.getMessage(PresenceIndicator.class, (String)"CTL_LogoutMenuItem"));
                menu.add(logoutItem);
                onlineCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    for (Kenai kenai : KenaiManager.getDefault().getKenais()) {
                                        PasswordAuthentication passwordAuthentication = kenai.getPasswordAuthentication();
                                        if (passwordAuthentication == null || !Utilities.isChatSupported(kenai)) continue;
                                        kenai.login(passwordAuthentication.getUserName(), passwordAuthentication.getPassword(), onlineCheckBox.isSelected());
                                    }
                                }
                                catch (KenaiException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        });
                    }
                });
                logoutItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LogoutAction.getDefault().actionPerformed(e);
                    }
                });
                contactListMenu.addActionListener(new WhoIsOnlineAction());
                menu.show(PresenceIndicator.this.label, event.getPoint().x, event.getPoint().y);
            }
        }
    }
}

