/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.api.ui;

import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.api.ui.FileObjectBasedFile;
import org.netbeans.modules.remote.api.ui.RemoteFileSystemView;

public final class FileChooserBuilder {
    private static final String openDialogTitleTextKey = "FileChooser.openDialogTitleText";
    private static final String saveDialogTitleTextKey = "FileChooser.saveDialogTitleText";
    private static final String readOnlyKey = "FileChooser.readOnly";
    private final ExecutionEnvironment env;

    public FileChooserBuilder(ExecutionEnvironment env) {
        this.env = env;
    }

    public JFileChooser createFileChooser() {
        return this.createFileChooser(null);
    }

    public JFileChooser createFileChooser(String selectedPath) {
        if (this.env.isLocal()) {
            return new JFileChooser(selectedPath);
        }
        if (selectedPath == null || selectedPath.trim().length() == 0) {
            selectedPath = "/";
        }
        String currentOpenTitle = UIManager.getString(openDialogTitleTextKey);
        String currentSaveTitle = UIManager.getString(saveDialogTitleTextKey);
        Boolean currentReadOnly = UIManager.getBoolean(readOnlyKey);
        UIManager.put(openDialogTitleTextKey, currentOpenTitle + " @ " + this.env.getDisplayName());
        UIManager.put(saveDialogTitleTextKey, currentSaveTitle + " @ " + this.env.getDisplayName());
        RemoteFileSystemView remoteFileSystemView = new RemoteFileSystemView("/", this.env);
        JFileChooserImpl chooser = new JFileChooserImpl(selectedPath, (FileSystemView)remoteFileSystemView);
        remoteFileSystemView.addPropertyChangeListener(chooser);
        UIManager.put(openDialogTitleTextKey, currentOpenTitle);
        UIManager.put(saveDialogTitleTextKey, currentSaveTitle);
        UIManager.put(readOnlyKey, currentReadOnly);
        return chooser;
    }

    private static class JFileChooserImpl
    extends JFileChooser
    implements PropertyChangeListener {
        public JFileChooserImpl(String currentDirectory, FileSystemView fsv) {
            super(currentDirectory, fsv);
        }

        protected void setup(FileSystemView view) {
            super.setup(view);
        }

        public void approveSelection() {
            File selectedFile = this.getSelectedFile();
            if (selectedFile != null) {
                if (selectedFile.isDirectory() && this.getFileSelectionMode() == 0) {
                    this.setCurrentDirectory(this.getSelectedFile());
                } else {
                    super.approveSelection();
                }
            }
        }

        public void setCurrentDirectory(File dir) {
            super.setCurrentDirectory(dir);
        }

        protected void fireActionPerformed(String command) {
            super.fireActionPerformed(command);
        }

        public void propertyChange(final PropertyChangeEvent evt) {
            if ("ls".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileObjectBasedFile file = (FileObjectBasedFile)evt.getNewValue();
                        if (file == null) {
                            JFileChooserImpl.this.setCursor(Cursor.getPredefinedCursor(0));
                        } else {
                            JFileChooserImpl.this.setCursor(Cursor.getPredefinedCursor(3));
                        }
                    }
                });
            }
        }
    }
}

