/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasServices;
import org.netbeans.modules.websvc.saas.model.oauth.Metadata;
import org.netbeans.modules.websvc.saas.model.wadl.Application;
import org.netbeans.modules.websvc.saas.model.wadl.Include;
import org.netbeans.modules.websvc.saas.model.wadl.Resource;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WadlSaas
extends Saas {
    private Application wadlModel;
    private List<WadlSaasResource> resources;
    private FileObject wadlFile;
    private List<FileObject> schemaFiles;
    private List<FileObject> jaxbJars;
    private List<FileObject> jaxbSourceJars;

    public WadlSaas(SaasGroup parentGroup, SaasServices services) {
        super(parentGroup, services);
    }

    public WadlSaas(SaasGroup parent, String url, String displayName, String packageName) {
        super(parent, url, displayName, packageName);
        this.getDelegate().setType("http://research.sun.com/wadl/2006/10");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application getWadlModel() throws IOException {
        if (this.wadlModel == null) {
            InputStream in = null;
            if (this.isUserDefined()) {
                if (this.getLocalWadlFile() != null) {
                    in = this.getLocalWadlFile().getInputStream();
                }
            } else {
                in = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getUrl());
            }
            try {
                if (in != null) {
                    this.wadlModel = SaasUtil.loadWadl(in);
                }
            }
            catch (JAXBException ex) {
                String msg = NbBundle.getMessage(WadlSaas.class, (String)"MSG_ErrorLoadingWadl", (Object)this.getUrl());
                IOException ioe = new IOException(msg);
                ioe.initCause(ex);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return this.wadlModel;
    }

    public List<WadlSaasResource> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<WadlSaasResource>();
            try {
                for (Resource r : this.getWadlModel().getResources().getResource()) {
                    this.resources.add(new WadlSaasResource(this, null, r));
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return Collections.emptyList();
            }
        }
        return new ArrayList<WadlSaasResource>(this.resources);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileObject getLocalWadlFile() {
        if (this.wadlFile != null) return this.wadlFile;
        try {
            if (this.isUserDefined()) {
                String path = this.getProperty("local.service.file");
                if (path != null) {
                    this.wadlFile = this.getSaasFolder().getFileObject(path);
                }
                if (this.wadlFile != null) return this.wadlFile;
                this.wadlFile = SaasUtil.retrieveWadlFile(this);
                if (this.wadlFile == null) throw new IllegalStateException(NbBundle.getMessage(WadlSaas.class, (String)"MSG_FailedToRetrieve") + " " + this.getUrl());
                path = FileUtil.getRelativePath((FileObject)this.saasFolder, (FileObject)this.wadlFile);
                this.setProperty("local.service.file", path);
                this.save();
                return this.wadlFile;
            } else {
                this.wadlFile = SaasUtil.extractWadlFile(this);
            }
            return this.wadlFile;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return this.wadlFile;
    }

    @Override
    protected WadlSaasMethod createSaasMethod(Method m) {
        return new WadlSaasMethod(this, m);
    }

    @Override
    public void toStateReady(boolean synchronous) {
        if (this.wadlModel == null) {
            this.setState(Saas.State.INITIALIZING);
            if (synchronous) {
                this.toStateReady();
            } else {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        WadlSaas.this.toStateReady();
                    }
                });
            }
        }
    }

    private void toStateReady() {
        try {
            this.getWadlModel();
            this.setState(Saas.State.RETRIEVED);
        }
        catch (Exception ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            this.setState(Saas.State.UNINITIALIZED);
            return;
        }
        this.setState(Saas.State.READY);
    }

    public String getBaseURL() {
        try {
            return this.getWadlModel().getResources().getBase();
        }
        catch (IOException ioe) {
            return NbBundle.getMessage(WadlSaas.class, (String)"LBL_BAD_WADL");
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.wadlFile != null) {
            try {
                this.wadlFile.getParent().delete();
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        this.wadlFile = null;
        this.wadlModel = null;
        this.resources = null;
        this.toStateReady(false);
    }

    public List<FileObject> getLocalSchemaFiles() throws IOException {
        if (this.wadlModel == null) {
            throw new IllegalStateException("Should transition state to at least RETRIEVED");
        }
        FileObject wadlDir = this.getLocalWadlFile().getParent();
        this.schemaFiles = new ArrayList<FileObject>();
        if (this.wadlModel.getGrammars() == null || this.wadlModel.getGrammars().getInclude() == null) {
            return this.schemaFiles;
        }
        for (Include include : this.wadlModel.getGrammars().getInclude()) {
            String uri = include.getHref();
            FileObject schemaFile = wadlDir.getFileObject(uri);
            if (schemaFile == null) {
                try {
                    URI xsdUri = new URI(this.getUrl()).resolve(uri);
                    String dirPath = SaasUtil.dirOnlyPath(uri);
                    schemaFile = SaasUtil.saveResourceAsFile(wadlDir, dirPath, xsdUri.getPath());
                }
                catch (URISyntaxException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            if (schemaFile == null) continue;
            this.schemaFiles.add(schemaFile);
        }
        return this.schemaFiles;
    }

    public Metadata getOauthMetadata() throws IOException, JAXBException {
        if (this.wadlModel == null) {
            throw new IllegalStateException("Should transition state to at least RETRIEVED");
        }
        if (this.wadlModel.getGrammars() == null || this.wadlModel.getGrammars().getAny() == null) {
            return null;
        }
        List<Object> otherGrammars = this.wadlModel.getGrammars().getAny();
        for (Object g : otherGrammars) {
            Element el;
            if (!(g instanceof Element) || !"http://netbeans.org/ns/oauth/metadata/1".equals((el = (Element)g).getNamespaceURI()) || !"metadata".equals(el.getLocalName())) continue;
            JAXBContext jc = JAXBContext.newInstance((String)"org.netbeans.modules.websvc.saas.model.oauth");
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement jaxbEl = u.unmarshal((Node)el, Metadata.class);
            return (Metadata)jaxbEl.getValue();
        }
        return null;
    }

    @Override
    public List<FileObject> getLibraryJars() {
        return this.jaxbJars;
    }

    public void setLibraryJars(List<FileObject> jaxbJars) {
        this.jaxbJars = jaxbJars;
    }

    public List<FileObject> getJaxbSourceJars() {
        return this.jaxbSourceJars;
    }

    public void setJaxbSourceJars(List<FileObject> jaxbSourceJars) {
        this.jaxbSourceJars = jaxbSourceJars;
    }
}

