/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.AID;
import com.sun.javacard.filemodels.DeploymentXmlAppletEntry;
import com.sun.javacard.filemodels.DeploymentXmlInstanceEntry;
import com.sun.javacard.filemodels.DeploymentXmlModel;
import com.sun.javacard.nbtasks.JCInstallerTask;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTask
extends JCInstallerTask {
    private String bundleName;
    private String instanceID;
    private File instancesFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        this.validateBundleName();
        if (this.isWebApplication()) {
            this.validateInstanceID();
        } else {
            this.validateInstancesFile();
        }
        if (this.isWebApplication()) {
            this.createArg().setValue("create");
            this.createArg().setValue("--name");
            this.createArg().setValue(this.bundleName);
            if (this.instanceID != null) {
                this.createArg().setValue("--instance");
                this.createArg().setValue(this.instanceID);
            }
            super.execute();
        } else {
            try {
                DeploymentXmlModel mdl;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.instancesFile));
                try {
                    mdl = new DeploymentXmlModel((InputStream)in);
                }
                finally {
                    in.close();
                }
                for (DeploymentXmlAppletEntry e : mdl.getData()) {
                    AID aid = e.getAppletAid();
                    this.instantiateForOneApplet(aid, e.getData());
                }
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
    }

    private void instantiateForOneApplet(AID appletAID, List<? extends DeploymentXmlInstanceEntry> instances) throws BuildException {
        for (DeploymentXmlInstanceEntry deploymentXmlInstanceEntry : instances) {
            String deployParams = deploymentXmlInstanceEntry.getDeploymentParams();
            AID instanceAID = deploymentXmlInstanceEntry.getInstanceAID();
            this.instantiateOneInstanceForOneApplet(appletAID, instanceAID, deployParams);
        }
    }

    private void instantiateOneInstanceForOneApplet(AID appletAID, AID instanceAID, String deployParams) throws BuildException {
        String applet_ID = appletAID.toString();
        String instance_ID = instanceAID.toString();
        String data = deployParams.trim();
        if (data.length() <= 0) {
            data = null;
        }
        super.clearArgs();
        this.createArg().setValue("create");
        this.createArg().setValue("--name");
        this.createArg().setValue(this.bundleName);
        if (applet_ID != null) {
            this.createArg().setValue("--applet");
            this.createArg().setValue(applet_ID);
        }
        if (instance_ID != null) {
            this.createArg().setValue("--instance");
            this.createArg().setValue(instance_ID);
        }
        if (data != null) {
            this.createArg().setValue("--data");
            this.createArg().setValue(data);
        }
        super.execute();
    }

    private void validateBundleName() throws BuildException {
        if (this.bundleName == null) {
            this.bundleName = this.getProject().getProperty("display.name");
        }
        if (this.bundleName == null) {
            throw new BuildException("BundleName value not specified");
        }
        this.bundleName = this.bundleName.trim();
        if (this.bundleName.length() <= 0) {
            throw new BuildException("Empty value for BundleName");
        }
    }

    private void validateInstanceID() throws BuildException {
        if (this.instanceID == null) {
            this.instanceID = this.getProp("webcontextpath", false);
        }
        if (this.instanceID == null) {
            this.instanceID = this.getProp("webcontextpath", false);
        }
        if (this.instanceID != null) {
            this.instanceID = this.instanceID.trim();
            if (this.instanceID.length() <= 0) {
                this.instanceID = null;
            }
        }
    }

    private void validateInstancesFile() {
        if (this.instancesFile == null) {
            this.instancesFile = new File(this.getProject().getBaseDir(), "nbproject" + File.separatorChar + "deployment.xml");
        }
        if (!this.instancesFile.exists()) {
            throw new BuildException("Instances File " + this.instancesFile.getAbsolutePath() + " not set or missing.");
        }
        if (!this.instancesFile.isFile()) {
            throw new BuildException(this.instancesFile.getPath() + " is not a regular file");
        }
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public void setInstanceID(String instanceID) {
        this.instanceID = instanceID;
    }

    public File getInstancesFile() {
        return this.instancesFile;
    }

    public void setInstancesFile(File instancesFile) {
        this.instancesFile = instancesFile;
    }
}

