/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.refactoring.HibernateMappingRenamePlugin;
import org.netbeans.modules.hibernate.refactoring.HibernateMappingRenameTransaction;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.refactoring.HibernateRenameRefactoringElement;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class HibernateMappingMovePlugin
implements RefactoringPlugin {
    private MoveRefactoring refactoring;
    private Project project;
    private String srcRoot;
    private ArrayList<MappingFileData> toBeMovedMappingFiles;

    public HibernateMappingMovePlugin(MoveRefactoring moveRefactoring) {
        this.refactoring = moveRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        URL uRL = (URL)this.refactoring.getTarget().lookup(URL.class);
        if (uRL == null) {
            return null;
        }
        String string = HibernateRefactoringUtil.getPackageName(uRL);
        if (string == null) {
            return null;
        }
        this.toBeMovedMappingFiles = this.getToBeMovedMappingFileData(string);
        ArrayList<MappingFileData> arrayList = this.getMappingFileDataInTargetPkg(string);
        Problem problem = null;
        for (MappingFileData mappingFileData : this.toBeMovedMappingFiles) {
            for (MappingFileData mappingFileData2 : arrayList) {
                if (mappingFileData.getFo().equals(mappingFileData2.getFo()) || !mappingFileData.getNewResourcename().equals(mappingFileData2.getResourceName())) continue;
                problem = HibernateRefactoringUtil.createProblem(problem, true, NbBundle.getMessage(HibernateMappingRenamePlugin.class, (String)"MSG_Name_Exists", (Object)mappingFileData.getFo().getNameExt()));
                return problem;
            }
        }
        return problem;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
        if (hibernateEnvironment == null) {
            return null;
        }
        List<FileObject> list = hibernateEnvironment.getAllHibernateConfigFileObjects();
        if (list.isEmpty()) {
            return null;
        }
        for (MappingFileData mappingFileData : this.toBeMovedMappingFiles) {
            Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> map = HibernateRefactoringUtil.getMappingResourceOccurrences(list, mappingFileData.getResourceName(), false);
            for (FileObject fileObject : map.keySet()) {
                List<HibernateRefactoringUtil.OccurrenceItem> list2 = map.get(fileObject);
                for (HibernateRefactoringUtil.OccurrenceItem occurrenceItem : list2) {
                    HibernateRenameRefactoringElement hibernateRenameRefactoringElement = new HibernateRenameRefactoringElement(fileObject, mappingFileData.getResourceName(), mappingFileData.getNewResourcename(), occurrenceItem.getLocation(), occurrenceItem.getText());
                    refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)hibernateRenameRefactoringElement);
                }
            }
            refactoringElementsBag.registerTransaction((Transaction)new HibernateMappingRenameTransaction(map.keySet(), mappingFileData.getResourceName(), mappingFileData.getNewResourcename()));
        }
        return null;
    }

    private ArrayList<MappingFileData> getToBeMovedMappingFileData(String string) {
        ArrayList<MappingFileData> arrayList = new ArrayList<MappingFileData>();
        for (FileObject fileObject : this.refactoring.getRefactoringSource().lookupAll(FileObject.class)) {
            SourceGroup[] sourceGroupArray;
            if (!fileObject.getMIMEType().equals("text/x-hibernate-mapping+xml")) continue;
            if (this.project == null) {
                this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
            }
            if (this.srcRoot == null) {
                sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)this.project);
                if (sourceGroupArray.length == 0) {
                    return null;
                }
                this.srcRoot = sourceGroupArray[0].getRootFolder().getPath();
            }
            sourceGroupArray = fileObject.getPath();
            String string2 = sourceGroupArray.substring(this.srcRoot.length() + 1);
            String string3 = string2.substring(string2.lastIndexOf("/") + 1);
            String string4 = string + "/" + string3;
            arrayList.add(new MappingFileData(fileObject, string2, string4));
        }
        return arrayList;
    }

    private ArrayList<MappingFileData> getMappingFileDataInTargetPkg(String string) {
        ArrayList<MappingFileData> arrayList = new ArrayList<MappingFileData>();
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)this.project.getLookup().lookup(HibernateEnvironment.class);
        if (hibernateEnvironment == null) {
            return arrayList;
        }
        List<FileObject> list = hibernateEnvironment.getAllHibernateMappingFileObjects();
        for (FileObject fileObject : list) {
            String string2;
            String string3 = fileObject.getPath();
            String string4 = string3.substring(this.srcRoot.length() + 1);
            int n = string4.lastIndexOf("/");
            if (n <= 0 || !(string2 = string4.substring(0, n)).equals(string)) continue;
            arrayList.add(new MappingFileData(fileObject, string4, null));
        }
        return arrayList;
    }

    private class MappingFileData {
        private FileObject fo;
        private String resourceName;
        private String newResourcename;

        public MappingFileData(FileObject fileObject, String string, String string2) {
            this.fo = fileObject;
            this.resourceName = string;
            this.newResourcename = string2;
        }

        public FileObject getFo() {
            return this.fo;
        }

        public String getNewResourcename() {
            return this.newResourcename;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

