/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ChartItemListener;

public interface ChartItem {
    public void addItemListener(ChartItemListener var1);

    public void removeItemListener(ChartItemListener var1);

    public static abstract class Abstract
    implements ChartItem {
        private List<ChartItemListener> listeners;

        @Override
        public void addItemListener(ChartItemListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ChartItemListener>();
            }
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        @Override
        public void removeItemListener(ChartItemListener listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }

        protected void fireItemChanged(ChartItemChange itemChange) {
            if (this.listeners != null) {
                for (ChartItemListener listener : this.listeners) {
                    listener.chartItemChanged(itemChange);
                }
            }
        }
    }
}

