/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

public final class JavaPlatformSelector
extends JPanel
implements ListSelectionListener {
    private static final String OK_BUTTON_NAME = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_OkButtonName");
    private static final String USE_SEL_PLATFORM_CHCKBOX_NAME = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_UseSelPlatformChckBoxName");
    private static final String NO_SUPPORTED_PLATFORM_MSG = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_NoSupportedPlatformMsg");
    private static final String SELECT_PLATFORM_CALIBRATE_MSG = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_SelectPlatformCalibrateMsg");
    private static final String SELECT_PLATFORM_CALIBRATE_DIALOG_CAPTION = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_SelectPlatformCalibrateDialogCaption");
    private static final String SELECT_PLATFORM_PROFILE_MSG = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_SelectPlatformProfileMsg");
    private static final String SELECT_PLATFORM_PROFILE_DIALOG_CAPTION = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_SelectPlatformProfileDialogCaption");
    private static final String CANNOT_USE_PLATFORM_MSG = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_CannotUsePlatform");
    private static final String LIST_ACCESS_NAME = NbBundle.getMessage(JavaPlatformSelector.class, (String)"JavaPlatformSelector_ListAccessName");
    private static JavaPlatformSelector defaultPlatform;
    private JLabel noteLabel;
    private JButton okButton = new JButton(OK_BUTTON_NAME);
    private JCheckBox alwaysCheckBox;
    private JList list;

    private JavaPlatformSelector() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.list = new JList();
        this.list.setVisibleRowCount(6);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.list.getAccessibleContext().setAccessibleName(LIST_ACCESS_NAME);
        this.noteLabel = new JLabel();
        this.noteLabel.setLabelFor(this.list);
        this.noteLabel.setFocusable(false);
        this.alwaysCheckBox = new JCheckBox(USE_SEL_PLATFORM_CHCKBOX_NAME, false);
        this.add((Component)new JScrollPane(this.list), "Center");
        this.add((Component)this.noteLabel, "North");
        this.add((Component)this.alwaysCheckBox, "South");
    }

    public static synchronized JavaPlatformSelector getDefault() {
        if (defaultPlatform == null) {
            defaultPlatform = new JavaPlatformSelector();
        }
        return defaultPlatform;
    }

    public static List getSupportedPlatforms() {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
        ArrayList<JavaPlatform> ret = new ArrayList<JavaPlatform>();
        for (int i = 0; i < platforms.length; ++i) {
            JavaPlatform platform = platforms[i];
            if (!MiscUtils.isSupportedJVM((Map)platform.getSystemProperties())) continue;
            ret.add(platforms[i]);
        }
        return ret;
    }

    public JavaPlatform selectPlatformForCalibration() {
        List platforms = JavaPlatformSelector.getSupportedPlatforms();
        if (platforms.size() == 0) {
            Profiler.getDefault().displayError(NO_SUPPORTED_PLATFORM_MSG);
            PlatformsCustomizer.showCustomizer(null);
            return null;
        }
        this.noteLabel.setText(SELECT_PLATFORM_CALIBRATE_MSG);
        this.noteLabel.getAccessibleContext().setAccessibleName(SELECT_PLATFORM_CALIBRATE_MSG);
        this.list.getAccessibleContext().setAccessibleDescription(SELECT_PLATFORM_CALIBRATE_MSG);
        this.list.setModel(new JPListModel(platforms));
        this.alwaysCheckBox.setVisible(false);
        DialogDescriptor dd = new DialogDescriptor((Object)this, SELECT_PLATFORM_CALIBRATE_DIALOG_CAPTION, true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        this.list.setSelectedIndex(0);
        this.validateOKButton();
        Dialog selectDialog = ProfilerDialogs.createDialog(dd);
        selectDialog.getAccessibleContext().setAccessibleDescription(SELECT_PLATFORM_CALIBRATE_DIALOG_CAPTION);
        selectDialog.setVisible(true);
        if (dd.getValue() == this.okButton) {
            int idx = this.list.getSelectedIndex();
            return (JavaPlatform)platforms.get(idx);
        }
        return null;
    }

    public JavaPlatform selectPlatformToUse() {
        List platforms = JavaPlatformSelector.getSupportedPlatforms();
        if (platforms.size() == 0) {
            Profiler.getDefault().displayError(NO_SUPPORTED_PLATFORM_MSG);
            PlatformsCustomizer.showCustomizer(null);
            return null;
        }
        this.noteLabel.setText("<html>" + CANNOT_USE_PLATFORM_MSG + "<br>" + SELECT_PLATFORM_PROFILE_MSG + "</html>");
        this.noteLabel.getAccessibleContext().setAccessibleName(CANNOT_USE_PLATFORM_MSG + SELECT_PLATFORM_PROFILE_MSG);
        this.list.getAccessibleContext().setAccessibleDescription(CANNOT_USE_PLATFORM_MSG + SELECT_PLATFORM_PROFILE_MSG);
        this.list.setModel(new JPListModel(platforms));
        this.alwaysCheckBox.setSelected(false);
        this.alwaysCheckBox.setVisible(true);
        DialogDescriptor dd = new DialogDescriptor((Object)this, SELECT_PLATFORM_PROFILE_DIALOG_CAPTION, true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        this.list.setSelectedIndex(0);
        this.validateOKButton();
        ProfilerDialogs.createDialog(dd).setVisible(true);
        if (dd.getValue() == this.okButton) {
            int idx = this.list.getSelectedIndex();
            JavaPlatform plat = (JavaPlatform)platforms.get(idx);
            if (this.alwaysCheckBox.isSelected()) {
                Profiler.getDefault().getGlobalProfilingSettings().setJavaPlatformForProfiling(plat == null ? null : plat.getDisplayName());
            }
            return plat;
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.validateOKButton();
    }

    private void validateOKButton() {
        this.okButton.setEnabled(this.list.getSelectedIndex() != -1);
    }

    public static class JPListModel
    extends AbstractListModel {
        private List platforms;

        private JPListModel(List platforms) {
            this.platforms = platforms;
        }

        @Override
        public Object getElementAt(int index) {
            return ((JavaPlatform)this.platforms.get(index)).getDisplayName();
        }

        @Override
        public int getSize() {
            return this.platforms.size();
        }
    }
}

