/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.oberthur;

import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.javacard.oberthur.StateUpdaterCallback;
import org.netbeans.modules.javacard.spi.AbstractCard;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.CardState;
import org.netbeans.modules.javacard.spi.ConnectionWatchdog;
import org.netbeans.modules.javacard.spi.ICardCapability;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.capabilities.CapabilitiesProvider;
import org.netbeans.modules.javacard.spi.capabilities.CardInfo;
import org.netbeans.modules.javacard.spi.capabilities.ContactedProtocol;
import org.netbeans.modules.javacard.spi.capabilities.PortKind;
import org.netbeans.modules.javacard.spi.capabilities.PortProvider;
import org.netbeans.modules.javacard.spi.capabilities.UrlCapability;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class CardImpl
extends AbstractCard {
    public static final String SINGLE_CARD_ID = "card";
    private static final String POLL_URL = "http://smartcard:80/SysInfo/getData";
    private static final String HOST = "smartcard";
    private volatile boolean connected;
    private final ConnectionWatchdog<CardImpl> watchdog = new ConnectionWatchdog((Card)this, (ConnectionWatchdog.Callback)new StateUpdaterCallback());

    CardImpl(JavacardPlatform pform) {
        super(pform, SINGLE_CARD_ID);
    }

    URL getPollUrl() throws MalformedURLException {
        return new URL(POLL_URL);
    }

    protected void onBeforeFirstLookup() {
        this.initCapabilities(new ICardCapability[]{new Ports(), new Info(), new Caps(), new Urls()});
    }

    public boolean isValid() {
        return true;
    }

    void setConnected(boolean connected) {
        if (this.connected != connected) {
            this.connected = connected;
            this.setState((connected &= super.isValid()) ? CardState.RUNNING : CardState.NOT_RUNNING);
        }
    }

    void refreshStatus() {
        this.watchdog.refreshNow();
    }

    private final class Urls
    implements UrlCapability {
        private Urls() {
        }

        public ContactedProtocol getContactedProtocol() {
            return null;
        }

        public String getURL() {
            return "http://smartcard/";
        }

        public String getManagerURL() {
            return CardImpl.POLL_URL;
        }

        public String getListURL() {
            return null;
        }
    }

    private final class Caps
    implements CapabilitiesProvider {
        private Caps() {
        }

        public Set<Class<? extends ICardCapability>> getSupportedCapabilityTypes() {
            HashSet<Class<? extends ICardCapability>> result = new HashSet<Class<? extends ICardCapability>>();
            result.add(CardInfo.class);
            result.add(PortProvider.class);
            result.add(CapabilitiesProvider.class);
            result.add(UrlCapability.class);
            return result;
        }
    }

    private final class Info
    implements CardInfo {
        private Info() {
        }

        public String getSystemId() {
            return CardImpl.SINGLE_CARD_ID;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(Info.class, (String)"CARD_DISPLAY_NAME");
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/javacard/oberthur/otcard.png");
        }

        public String getDescription() {
            PortProvider p = (PortProvider)CardImpl.this.getCapability(PortProvider.class);
            return NbBundle.getMessage(Info.class, (String)"CARD_DESCRIPTION", (Object)p.getHost(), p.getClaimedPorts().iterator().next(), (Object)CardImpl.this.getPlatform().getDisplayName());
        }
    }

    private final class Ports
    implements PortProvider {
        private Ports() {
        }

        public Set<Integer> getClaimedPorts() {
            return Collections.singleton(80);
        }

        public Set<Integer> getPortsInUse() {
            return CardImpl.this.connected ? this.getPortsInUse() : Collections.emptySet();
        }

        public String getHost() {
            return CardImpl.HOST;
        }

        public int getPort(PortKind role) {
            switch (role) {
                case HTTP: {
                    return 80;
                }
            }
            return -1;
        }
    }
}

