/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.expressions.DataExpression;
import oracle.toplink.essentials.internal.expressions.ExpressionJavaPrinter;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.SQLSelectStatement;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;

public class FieldExpression
extends DataExpression {
    protected DatabaseField field;
    protected transient DatabaseField aliasedField;

    public FieldExpression() {
    }

    public FieldExpression(DatabaseField newField) {
        this.field = newField;
    }

    public FieldExpression(DatabaseField newField, Expression myBase) {
        this.field = newField;
        this.baseExpression = myBase;
    }

    public void clearAliases() {
        super.clearAliases();
        this.aliasedField = null;
    }

    public String descriptionOfNodeType() {
        return "Field";
    }

    public DatabaseField getAliasedField() {
        if (this.aliasedField == null) {
            this.initializeAliasedField();
        }
        return this.aliasedField;
    }

    private DatabaseTable getAliasedTable() {
        DatabaseTable alias;
        DataExpression base = (DataExpression)this.getBaseExpression();
        if (!this.getField().hasTableName()) {
            base.getDescriptor().buildField(this.getField());
        }
        if ((alias = base.aliasForTable(this.getField().getTable())) == null) {
            return this.getField().getTable();
        }
        return alias;
    }

    public DatabaseField getClonedField() {
        return (DatabaseField)this.getField().clone();
    }

    public Vector getClonedFields() {
        Vector<Object> result = new Vector<Object>(1);
        result.addElement(this.getField().clone());
        return result;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public Vector getFields() {
        Vector<DatabaseField> result = new Vector<DatabaseField>(1);
        result.addElement(this.getField());
        return result;
    }

    private void initializeAliasedField() {
        DatabaseField tempField = (DatabaseField)this.getField().clone();
        DatabaseTable aliasedTable = this.getAliasedTable();
        this.aliasedField = tempField;
        this.aliasedField.setTable(aliasedTable);
    }

    public boolean isAttribute() {
        return true;
    }

    public boolean isFieldExpression() {
        return true;
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        printer.printField(this.getAliasedField());
    }

    public void printJava(ExpressionJavaPrinter printer) {
        this.getBaseExpression().printJava(printer);
        printer.printString(".getField(\"" + this.getField().getQualifiedName() + "\")");
    }

    public Expression rebuildOn(Expression newBase) {
        FieldExpression expression = new FieldExpression(this.getField(), this.getBaseExpression().rebuildOn(newBase));
        expression.setSelectIfOrderedBy(this.selectIfOrderedBy());
        return expression;
    }

    public void setField(DatabaseField newField) {
        this.field = newField;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        Expression twistedBase = this.getBaseExpression().twistedForBaseAndContext(newBase, context);
        return twistedBase.getField(this.getField());
    }

    public void validateNode() {
        Vector tables;
        DataExpression base = (DataExpression)this.getBaseExpression();
        if (this.getField().getTable().hasName() && (tables = base.getOwnedTables()) != null && !tables.contains(this.getField().getTable())) {
            throw QueryException.invalidTableForFieldInExpression(this.getField());
        }
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean isObjectUnregistered) {
        if (this.getBuilder() != this.getBaseExpression()) {
            throw QueryException.cannotConformExpression();
        }
        DatabaseMapping mapping = session.getDescriptor(object.getClass()).getObjectBuilder().getMappingForField(this.getField());
        if (mapping == null) {
            throw QueryException.cannotConformExpression();
        }
        return mapping.valueFromObject(object, this.getField(), session);
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.getField().toString());
    }

    public void writeFields(ExpressionSQLPrinter printer, Vector newFields, SQLSelectStatement statement) {
        DatabaseField field = this.getField();
        if (field != null) {
            newFields.addElement(field);
            this.writeField(printer, field, statement);
        }
    }
}

