/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.testrunner.ui;

import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.testrunner.ui.JumpToCallStackAction;
import org.netbeans.modules.cnd.testrunner.ui.JumpToTestAction;
import org.netbeans.modules.cnd.testrunner.ui.RunTestMethodAction;
import org.netbeans.modules.gsf.testrunner.api.DiffViewAction;
import org.netbeans.modules.gsf.testrunner.api.Locator;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class CndTestMethodNode
extends TestMethodNode {
    public CndTestMethodNode(Testcase testcase, Project project) {
        super(testcase, project, Lookups.singleton((Object)new Locator(){

            public void jumpToSource(Node node) {
                node.getPreferredAction().actionPerformed(null);
            }
        }));
    }

    public Action getPreferredAction() {
        String testLocation = CndTestMethodNode.getTestLocation(this.testcase, this.project);
        String stackTrace = CndTestMethodNode.getTestCaseLineFromStackTrace(this.testcase);
        String jumpToLocation = stackTrace != null ? stackTrace : testLocation;
        return jumpToLocation == null ? new JumpToTestAction(this.testcase, this.project, NbBundle.getMessage(CndTestMethodNode.class, (String)"LBL_GoToSource"), false) : new JumpToCallStackAction((Node)this, jumpToLocation);
    }

    static String getTestLocation(Testcase testcase, Project project) {
        if (testcase.getLocation() == null) {
            return null;
        }
        return testcase.getLocation();
    }

    private static String getTestCaseLineFromStackTrace(Testcase testcase) {
        int j;
        if (testcase.getTrouble() == null) {
            return null;
        }
        String[] stacktrace = testcase.getTrouble().getStackTrace();
        if (stacktrace == null || stacktrace.length <= 1) {
            return null;
        }
        for (j = 1; j < stacktrace.length && stacktrace[j].contains("unittest.py"); ++j) {
        }
        if (j == stacktrace.length) {
            j = stacktrace.length - 1;
        }
        return stacktrace[j];
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return new Action[0];
        }
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(this.getPreferredAction());
        actions.add(new DiffViewAction(this.testcase));
        actions.add((Object)new RunTestMethodAction(this.testcase, this.project, NbBundle.getMessage(CndTestMethodNode.class, (String)"LBL_RerunTest"), false));
        actions.add((Object)new RunTestMethodAction(this.testcase, this.project, NbBundle.getMessage(CndTestMethodNode.class, (String)"LBL_DebugTest"), true));
        return actions.toArray(new Action[actions.size()]);
    }
}

