/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.db.sql.editor.SQLSyntax;
import org.netbeans.modules.db.sql.editor.SQLSyntaxSupport;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionEnv;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.modules.editor.NbEditorKit;

public class SQLEditorKit
extends NbEditorKit {
    public static final String MIME_TYPE = "text/x-sql";

    public Syntax createSyntax(Document doc) {
        return new SQLSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new SQLSyntaxSupport(doc);
    }

    protected Action[] createActions() {
        Action[] superActions = super.createActions();
        Action[] sqlActions = new Action[]{new SQLDefaultKeyTypedAction(), new ExtKit.ToggleCommentAction("--")};
        return TextAction.augmentList(superActions, sqlActions);
    }

    public String getContentType() {
        return MIME_TYPE;
    }

    public static class SQLDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void insertString(BaseDocument doc, int caretOffset, Caret caret, String str, boolean overwrite) throws BadLocationException {
            char insertedChar = str.charAt(0);
            if ((insertedChar == '\"' || insertedChar == '\'') && SQLDefaultKeyTypedAction.canCompleteQuote(doc, caretOffset)) {
                super.insertString(doc, caretOffset, caret, String.valueOf(insertedChar) + insertedChar, overwrite);
                caret.setDot(caretOffset + 1);
                return;
            }
            super.insertString(doc, caretOffset, caret, str, overwrite);
        }

        private static boolean canCompleteQuote(BaseDocument doc, int caretOffset) {
            SQLCompletionEnv env = SQLCompletionEnv.forDocument((Document)doc, caretOffset);
            TokenSequence<SQLTokenId> seq = env.getTokenSequence();
            if (seq.move(caretOffset) == 0 && seq.movePrevious()) {
                switch ((SQLTokenId)seq.token().id()) {
                    case WHITESPACE: 
                    case DOT: {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

