/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io.editor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.io.editor.CodeEditorTopComponent;
import org.netbeans.modules.vmd.io.editor.DataEditorViewLookupFactoryRegistry;
import org.netbeans.modules.vmd.io.editor.EditorTopComponent;
import org.openide.awt.UndoRedo;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class EditorViewElement
implements MultiViewElement,
Serializable {
    private static final long serialVersionUID = -1L;
    private static final String CLOSING_ID = "ID_JAVA_CLOSING";
    private DataObjectContext context;
    private DataEditorView view;
    private transient DataEditorView.Kind kind;
    private transient Lookup lookup;
    private transient EditorTopComponent topComponent;
    private transient MultiViewElementCallback callback;

    public EditorViewElement() {
    }

    public EditorViewElement(DataObjectContext context, DataEditorView view) {
        this.context = context;
        this.view = view;
        this.init();
    }

    private void init() {
        this.kind = this.view.getKind();
        ArrayList<Object> lookupObjects = DataEditorViewLookupFactoryRegistry.getLookupObjects(this.context, this.view);
        ArrayList<Lookup> lookups = DataEditorViewLookupFactoryRegistry.getLookups(this.context, this.view);
        lookupObjects.add(this.view);
        if (this.view.getKind() == DataEditorView.Kind.MODEL) {
            lookups.add(Lookups.exclude((Lookup)this.context.getDataObject().getLookup(), (Class[])new Class[]{Node.class, SaveAsCapable.class}));
        }
        lookups.add(Lookups.fixed((Object[])lookupObjects.toArray()));
        this.lookup = new ProxyLookup(lookups.toArray(new Lookup[lookups.size()]));
        IOSupport.getDocumentSerializer(this.context.getDataObject()).startLoadingDocument();
    }

    public JComponent getVisualRepresentation() {
        JComponent visualRepresentation;
        if (this.topComponent == null && (visualRepresentation = this.view.getVisualRepresentation()) != null) {
            if (this.view.getHelpCtx() != null) {
                HelpCtx.setHelpIDString((JComponent)visualRepresentation, (String)this.view.getHelpCtx().getHelpID());
            }
            this.topComponent = this.kind == DataEditorView.Kind.CODE ? new CodeEditorTopComponent(this.context, this.lookup, visualRepresentation) : new EditorTopComponent(this.context, this.lookup, visualRepresentation);
        }
        return this.topComponent;
    }

    public JComponent getToolbarRepresentation() {
        return this.view.getToolbarRepresentation();
    }

    public Action[] getActions() {
        return this.callback != null ? this.callback.createDefaultActions() : new Action[]{};
    }

    public Lookup getLookup() {
        this.getVisualRepresentation();
        return this.topComponent.getLookup();
    }

    public void componentOpened() {
        this.view.componentOpened();
    }

    public void componentClosed() {
        this.view.componentClosed();
    }

    public void componentShowing() {
        this.view.componentShowing();
    }

    public void componentHidden() {
        this.view.componentHidden();
    }

    public void componentActivated() {
        IOSupport.notifyDataEditorViewActivated(this.view);
        this.view.componentActivated();
    }

    public void componentDeactivated() {
        this.view.componentDeactivated();
    }

    public UndoRedo getUndoRedo() {
        UndoRedo undoRedo = this.view.getUndoRedo();
        if (undoRedo != null) {
            return undoRedo;
        }
        if (this.kind != DataEditorView.Kind.MODEL) {
            return null;
        }
        return IOSupport.getDocumentSerializer(this.context.getDataObject()).getUndoRedoManager();
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
        IOSupport.getDataObjectInteface(this.context.getDataObject()).setMVTC(callback.getTopComponent());
    }

    public CloseOperationState canCloseElement() {
        return MultiViewFactory.createUnsafeCloseState((String)CLOSING_ID, null, null);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.context);
        out.writeObject(this.view);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object = in.readObject();
        if (!(object instanceof DataObjectContext)) {
            throw new ClassNotFoundException("DataObjectContext expected but not found");
        }
        this.context = (DataObjectContext)object;
        object = in.readObject();
        if (!(object instanceof DataEditorView)) {
            throw new ClassNotFoundException("DataEditorView expected but not found");
        }
        this.view = (DataEditorView)object;
        this.init();
    }
}

