/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io.serialization;

import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandler;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class DocumentErrorHandlerSupport {
    public static void showDocumentErrorHandlerDialog(final DocumentErrorHandler errorHandler, final FileObject file) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogDescriptor descriptor;
                String message;
                if (errorHandler.getErrors().isEmpty() && errorHandler.getWarnings().isEmpty()) {
                    return;
                }
                StringBuffer warnings = new StringBuffer();
                if (!errorHandler.getWarnings().isEmpty()) {
                    warnings.append("<HTML>  " + NbBundle.getMessage(DocumentErrorHandlerSupport.class, (String)"MSG_DialogWarning") + "<FONT COLOR=BLUE> <UL>");
                    for (String warning : errorHandler.getWarnings()) {
                        warnings.append("<LI>");
                        warnings.append(warning);
                        warnings.append("</LI>");
                    }
                    warnings.append("</UL>");
                    warnings.append("</FONT COLOR");
                }
                StringBuffer errors = new StringBuffer();
                if (!errorHandler.getErrors().isEmpty()) {
                    errors.append("<HTML> " + NbBundle.getMessage(DocumentErrorHandlerSupport.class, (String)"MSG_DialogError") + "<FONT COLOR=BLUE> <UL>");
                    for (String error : errorHandler.getErrors()) {
                        errors.append("<LI>");
                        errors.append(error);
                        errors.append("</LI>");
                    }
                    errors.append("</UL>");
                    errors.append("</FONT COLOR");
                }
                String title = NbBundle.getMessage(DocumentErrorHandlerSupport.class, (String)"MSG_DialogTitle") + " " + file.getName();
                String closeButton = NbBundle.getMessage(DocumentErrorHandlerSupport.class, (String)"MSG_close_button");
                String openButton = NbBundle.getMessage(DocumentErrorHandlerSupport.class, (String)"MSG_open_button");
                if (!errorHandler.getErrors().isEmpty()) {
                    message = errors.toString() + warnings.toString() + NbBundle.getMessage(DocumentErrorHandlerSupport.class, (String)"MSG_Error");
                    descriptor = new DialogDescriptor((Object)message, title, true, new Object[]{closeButton}, null, 0, HelpCtx.DEFAULT_HELP, null);
                } else {
                    message = errors.toString() + warnings.toString() + NbBundle.getMessage(DocumentErrorHandlerSupport.class, (String)"MSG_Warning");
                    descriptor = new DialogDescriptor((Object)message, title, true, new Object[]{openButton, closeButton}, null, 0, HelpCtx.DEFAULT_HELP, null);
                }
                try {
                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                    if (result != openButton) {
                        IOSupport.getCloneableEditorSupport(DataObject.find((FileObject)file)).close();
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }
}

