/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.ClientStubsGenerator;
import org.netbeans.modules.websvc.rest.codegen.JMakiRestWidgetGenerator;
import org.netbeans.modules.websvc.rest.wizard.ClientStubsSetupPanel;
import org.netbeans.modules.websvc.rest.wizard.ProgressDialog;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ClientStubsIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private RequestProcessor.Task generatorTask;

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            String string = NbBundle.getMessage(ClientStubsSetupPanel.class, (String)"LBL_SelectRestServiceProjects");
            this.panels = new WizardDescriptor.Panel[]{new ClientStubsSetupPanel(string, this.wizard)};
            String[] stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = component.getName();
                }
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        final FileObject fileObject = (FileObject)this.wizard.getProperty("StubRootFolder");
        final String string = (String)this.wizard.getProperty("StubFolderName");
        final boolean bl = (Boolean)this.wizard.getProperty("ProjectSelection");
        final Project[] projectArray = (Project[])this.wizard.getProperty("ProjectToStub");
        final FileObject fileObject2 = (FileObject)this.wizard.getProperty("WadlToStub");
        final boolean bl2 = (Boolean)this.wizard.getProperty("OverwriteExisting");
        final boolean bl3 = (Boolean)this.wizard.getProperty("CreateJMakiRestComponents");
        final HashSet hashSet = new HashSet();
        try {
            final ProgressDialog progressDialog = new ProgressDialog(NbBundle.getMessage(ClientStubsIterator.class, (String)"LBL_ClientStubsProgress"));
            this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressHandle progressHandle = progressDialog.getProgressHandle();
                    try {
                        if (bl) {
                            for (Project project : projectArray) {
                                if (bl3) {
                                    hashSet.addAll(new JMakiRestWidgetGenerator(fileObject, string, project, bl3, bl2).generate(progressHandle));
                                    continue;
                                }
                                hashSet.addAll(new ClientStubsGenerator(fileObject, string, project, bl2).generate(progressHandle));
                            }
                        } else if (!bl3) {
                            hashSet.addAll(new ClientStubsGenerator(fileObject, string, fileObject2, bl2).generate(progressHandle));
                        }
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                    finally {
                        progressDialog.close();
                    }
                }
            });
            this.generatorTask.schedule(50);
            Object[] objectArray = new Object[5];
            objectArray[0] = "JAX-RS";
            Project project = Templates.getProject((WizardDescriptor)this.wizard);
            objectArray[1] = project.getClass().getName();
            J2eeModule j2eeModule = RestUtils.getJ2eeModule(project);
            objectArray[2] = j2eeModule == null ? null : j2eeModule.getModuleVersion() + "(WAR)";
            boolean bl4 = (Boolean)this.wizard.getProperty("CreateJMakiRestComponents");
            objectArray[3] = bl4 ? "REST CLIENT JMAKI" : "REST CLIENT";
            objectArray[4] = this.wizard.getProperty("WadlToStub") != null ? "FROM WADL" : "FROM PROJECT";
            LogUtils.logWsWizard((Object[])objectArray);
            progressDialog.open();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return hashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        wizardDescriptor.putProperty("NewFileWizard_Title", (Object)this.name());
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return NbBundle.getMessage(ClientStubsIterator.class, (String)"Templates/WebServices/RestClientStubs");
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }
}

