/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.acl.NotOwnerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightDeploymentService;
import org.netbeans.modules.dlight.api.execution.DLightDeploymentTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.dtrace.collector.DtraceParser;
import org.netbeans.modules.dlight.dtrace.collector.impl.DTDCConfigurationAccessor;
import org.netbeans.modules.dlight.dtrace.collector.support.BootstrapScript;
import org.netbeans.modules.dlight.dtrace.collector.support.DTraceScriptUtils;
import org.netbeans.modules.dlight.dtrace.collector.support.DtraceDataAndStackParser;
import org.netbeans.modules.dlight.extras.api.support.CollectorRunner;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListener;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.dlight.util.usagetracking.SunStudioUserCounter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupport;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupportProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class DtraceDataCollector
extends IndicatorDataProvider<DTDCConfiguration>
implements DataCollector<DTDCConfiguration> {
    private static final List<String> ultimateDTracePrivilegesList = Arrays.asList("dtrace_kernel", "dtrace_proc", "dtrace_user");
    private static final String cmd_dtrace = "/usr/sbin/dtrace";
    private static final Logger log = DLightLogger.getLogger(DtraceDataCollector.class);
    private final Set<String> requiredPrivilegesSet = new HashSet<String>();
    private DataTableMetadata tableMetaData = null;
    private URL localScriptUrl;
    private String extraArgs;
    private String scriptPath;
    private CollectorRunner dtraceRunner = null;
    private DTDCConfiguration configuration;
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private List<ValidationListener> validationListeners = Collections.synchronizedList(new ArrayList());
    private String command;
    private String argsTemplate;
    private DataStorage storage;
    private List<DataTableMetadata> dataTablesMetadata;
    private DtraceParser parser;
    private final List<DataRow> indicatorDataBuffer = new ArrayList<DataRow>();
    private int indicatorFiringFactor;
    private LineProcessor outputProcessor = new DefaultLineProcessor();
    private boolean isSlave;
    private final boolean multiScriptMode;
    private DtraceDataCollector parentCollector;
    private final Map<String, DtraceDataCollector> slaveCollectors;
    private DtraceDataCollector lastSlaveCollector;
    private final List<DataCollectorListener> listeners = new ArrayList<DataCollectorListener>();
    private boolean terminated = false;
    private boolean isDeploymentTarget = false;

    DtraceDataCollector(boolean multiScriptMode, DTDCConfiguration configuration) {
        this.multiScriptMode = multiScriptMode;
        this.command = cmd_dtrace;
        this.argsTemplate = null;
        DTDCConfigurationAccessor cfgInfo = DTDCConfigurationAccessor.getDefault();
        if (multiScriptMode) {
            this.dataTablesMetadata = new ArrayList<DataTableMetadata>();
            this.tableMetaData = null;
            this.slaveCollectors = new HashMap<String, DtraceDataCollector>();
            this.setOutputProcessor(new DemultiplexingLineProcessor());
            this.addSlaveConfiguration(configuration);
        } else {
            assert (cfgInfo.getScriptUrl(configuration) != null);
            this.dataTablesMetadata = cfgInfo.getDatatableMetadata(configuration);
            this.slaveCollectors = Collections.emptyMap();
            DataTableMetadata dataTableMetadata = this.tableMetaData = this.dataTablesMetadata != null && this.dataTablesMetadata.size() > 0 ? this.dataTablesMetadata.get(0) : null;
            this.parser = cfgInfo.isStackSupportEnabled(configuration) ? new DtraceDataAndStackParser(this.tableMetaData) : (cfgInfo.getParser(configuration) == null ? (this.tableMetaData != null ? new DtraceParser(this.tableMetaData) : (DtraceParser)null) : cfgInfo.getParser(configuration));
            this.localScriptUrl = cfgInfo.getScriptUrl(configuration);
            this.extraArgs = cfgInfo.getArgs(configuration);
            List<String> requiredPrivileges = cfgInfo.getRequiredPrivileges(configuration);
            if (requiredPrivileges != null) {
                this.requiredPrivilegesSet.addAll(requiredPrivileges);
            } else {
                this.requiredPrivilegesSet.addAll(ultimateDTracePrivilegesList);
            }
            this.configuration = configuration;
            this.indicatorFiringFactor = cfgInfo.getIndicatorFiringFactor(configuration);
        }
        this.terminated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDataCollectorListener(DataCollectorListener listener) {
        if (listener == null) {
            return;
        }
        DtraceDataCollector dtraceDataCollector = this;
        synchronized (dtraceDataCollector) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDataCollectorListener(DataCollectorListener listener) {
        DtraceDataCollector dtraceDataCollector = this;
        synchronized (dtraceDataCollector) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyListeners(final DataCollector.CollectorState state) {
        DataCollectorListener[] ll;
        DtraceDataCollector dtraceDataCollector = this;
        synchronized (dtraceDataCollector) {
            ll = this.listeners.toArray(new DataCollectorListener[0]);
        }
        final CountDownLatch doneFlag = new CountDownLatch(ll.length);
        for (final DataCollectorListener l : ll) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        l.collectorStateChanged((DataCollector)DtraceDataCollector.this, state);
                    }
                    finally {
                        doneFlag.countDown();
                    }
                }
            }, (String)("Notifying " + l));
        }
        try {
            doneFlag.await();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    void addSlaveConfiguration(DTDCConfiguration configuration) {
        if (!this.multiScriptMode) {
            throw new IllegalStateException("addSlaveConfiguration called in single-script mode");
        }
        for (DtraceDataCollector dc : this.slaveCollectors.values()) {
            if (dc.configuration != configuration) continue;
            return;
        }
        DTDCConfigurationAccessor accessor = DTDCConfigurationAccessor.getDefault();
        List<String> requiredPrivileges = accessor.getRequiredPrivileges(configuration);
        this.requiredPrivilegesSet.addAll(requiredPrivileges == null ? ultimateDTracePrivilegesList : requiredPrivileges);
        if (accessor.getScriptUrl(configuration) == null) {
            return;
        }
        DtraceDataCollector slaveCollector = new DtraceDataCollector(false, configuration);
        slaveCollector.setSlave(true);
        slaveCollector.setParentCollector(this);
        this.slaveCollectors.put(accessor.getOutputPrefix(configuration), slaveCollector);
    }

    void setParentCollector(DtraceDataCollector parentCollector) {
        this.parentCollector = parentCollector;
    }

    public String getName() {
        return "DTrace";
    }

    void setOutputProcessor(LineProcessor callback) {
        this.outputProcessor = callback;
    }

    void setSlave(boolean isSlave) {
        this.isSlave = isSlave;
    }

    URL getLocalScriptUrl() {
        return this.localScriptUrl;
    }

    void setLocalScriptUrl(URL path) {
        this.localScriptUrl = path;
    }

    LineProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    protected DataStorage getStorage() {
        return this.storage;
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        DataStorageTypeFactory dstf = DataStorageTypeFactory.getInstance();
        DataStorageType sqlStorageType = dstf.getDataStorageType("db:sql");
        DataStorageType stackStorageType = dstf.getDataStorageType("stack");
        return Arrays.asList(sqlStorageType, stackStorageType);
    }

    public boolean isAttachable() {
        return true;
    }

    public void init(Map<DataStorageType, DataStorage> storages, DLightTarget target) {
        File scriptFile;
        if (this.multiScriptMode) {
            for (DtraceDataCollector ddc : this.slaveCollectors.values()) {
                ddc.init(storages, target);
            }
            try {
                this.setLocalScriptUrl(this.mergeScripts().toURI().toURL());
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        DataStorageTypeFactory dstf = DataStorageTypeFactory.getInstance();
        this.storage = storages.get(dstf.getDataStorageType("db:sql"));
        StackDataStorage stackStorage = (StackDataStorage)storages.get(dstf.getDataStorageType("stack"));
        if (this.parser instanceof DtraceDataAndStackParser) {
            ((DtraceDataAndStackParser)this.parser).setStackDataStorage(stackStorage);
        }
        if (this.isSlave) {
            return;
        }
        try {
            scriptFile = Util.copyToTempDir((URL)this.localScriptUrl);
            if (!this.needsBootstrap()) {
                DTraceScriptUtils.insertEOFMarker(scriptFile);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            this.scriptPath = null;
            return;
        }
        ExecutionEnvironment execEnv = target.getExecEnv();
        this.scriptPath = DTraceScriptUtils.uploadScript(execEnv, scriptFile);
        if (this.needsBootstrap()) {
            ServiceInfoDataStorage info = this.getServiceInfoDataStorage();
            assert (info != null);
            String pattern = info.getValue("DTraceTracingPattern");
            BootstrapScript bootstrap = new BootstrapScript(this.scriptPath, pattern);
            try {
                this.scriptPath = bootstrap.getScriptPath(execEnv);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.scriptPath = null;
                return;
            }
        }
    }

    public String getCmd() {
        return this.command;
    }

    public String[] getArgs() {
        return null;
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        ArrayList<DataTableMetadata> ret = new ArrayList<DataTableMetadata>();
        ret.addAll(this.dataTablesMetadata);
        for (DtraceDataCollector ddc : this.slaveCollectors.values()) {
            ret.addAll(ddc.getDataTablesMetadata());
        }
        return ret;
    }

    protected String getCollectorTaskExtraParams() {
        return this.extraArgs;
    }

    void packageVisibleSuggestIndicatorsRepaint() {
        super.suggestIndicatorsRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetFinished(DLightTarget target) {
        if (!this.isSlave && this.dtraceRunner != null) {
            log.fine("Stopping DtraceDataCollector: " + this.dtraceRunner.toString());
            this.dtraceRunner.shutdown();
        }
        if (this.isDeploymentTarget && this.terminated) {
            return;
        }
        List<DataRow> list = this.indicatorDataBuffer;
        synchronized (list) {
            if (!this.indicatorDataBuffer.isEmpty()) {
                if (this.isSlave) {
                    if (this.parentCollector != null) {
                        this.parentCollector.notifyIndicators(this.indicatorDataBuffer);
                    }
                } else {
                    this.notifyIndicators(this.indicatorDataBuffer);
                }
                this.indicatorDataBuffer.clear();
            }
        }
    }

    private static String loc(String key, String ... param) {
        return NbBundle.getMessage(DtraceDataCollector.class, (String)key, (Object[])param);
    }

    private ValidationStatus doValidation(DLightTarget target) {
        DLightLogger.assertNonUiThread();
        ExecutionEnvironment execEnv = target.getExecEnv();
        ConnectionManager mgr = ConnectionManager.getInstance();
        boolean isConnected = mgr.isConnectedTo(execEnv);
        if (!isConnected) {
            Runnable doOnConnect = new Runnable(){

                @Override
                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            };
            AsynchronousAction connectAction = mgr.getConnectToAction(execEnv, doOnConnect);
            return ValidationStatus.unknownStatus((String)DtraceDataCollector.loc("ValidationStatus.HostNotConnected", new String[0]), (AsynchronousAction)connectAction);
        }
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            if (hostInfo == null || hostInfo.getOSFamily() != HostInfo.OSFamily.SUNOS) {
                return ValidationStatus.invalidStatus((String)NbBundle.getMessage(DtraceDataCollector.class, (String)"DtraceDataCollector.DtraceIsSupportedOnSunOSOnly"));
            }
            if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)this.command)) {
                return ValidationStatus.invalidStatus((String)DtraceDataCollector.loc("ValidationStatus.CommandNotFound", this.command));
            }
        }
        catch (Exception ex) {
            return ValidationStatus.invalidStatus((String)DtraceDataCollector.loc("ValidationStatus.ErrorWhileValidation", ex.getMessage()));
        }
        ProcessUtils.ExitStatus zonenameResult = ProcessUtils.execute((ExecutionEnvironment)execEnv, (String)"/sbin/zonename", (String[])new String[0]);
        if (!zonenameResult.isOK() || !"global".equals(zonenameResult.output)) {
            return ValidationStatus.invalidStatus((String)DtraceDataCollector.loc("ValidationStatus.NotGlobalZone", this.command));
        }
        SolarisPrivilegesSupport sps = SolarisPrivilegesSupportProvider.getSupportFor((ExecutionEnvironment)execEnv);
        if (sps == null) {
            return ValidationStatus.invalidStatus((String)NbBundle.getMessage(DtraceDataCollector.class, (String)"DtraceDataCollector.NoPrivSupport", (Object)execEnv.toString()));
        }
        boolean status = sps.hasPrivileges(this.requiredPrivilegesSet);
        if (!status) {
            try {
                sps.requestPrivileges(this.requiredPrivilegesSet, false);
                status = true;
            }
            catch (NotOwnerException ex) {
                // empty catch block
            }
        }
        if (!status) {
            Runnable onPrivilegesGranted = new Runnable(){

                @Override
                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            };
            AsynchronousAction requestPrivilegesAction = sps.getRequestPrivilegesAction(this.requiredPrivilegesSet, onPrivilegesGranted);
            return ValidationStatus.unknownStatus((String)DtraceDataCollector.loc("DTraceDataCollector_Status_NotEnoughPrivileges", new String[0]), (AsynchronousAction)requestPrivilegesAction);
        }
        return ValidationStatus.validStatus();
    }

    public ValidationStatus validate(DLightTarget target) {
        ValidationStatus status = this.validate(target, (Validateable<DLightTarget>)this, true);
        if (status.isValid()) {
            SunStudioUserCounter.countDLight((ExecutionEnvironment)target.getExecEnv());
        }
        return status;
    }

    ValidationStatus validate(DLightTarget target, Validateable<DLightTarget> validatebleSource, boolean notify) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus oldStatus = this.validationStatus;
        ValidationStatus newStatus = this.doValidation(target);
        if (notify) {
            this.notifyStatusChanged(validatebleSource, oldStatus, newStatus);
        }
        this.validationStatus = newStatus;
        return newStatus;
    }

    public void invalidate() {
        this.validationStatus = ValidationStatus.initialStatus();
    }

    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    private void targetStarted(DLightTarget target) {
        if (this.isSlave || this.scriptPath == null) {
            return;
        }
        String taskCommand = this.scriptPath;
        if (target instanceof AttachableTarget) {
            AttachableTarget at = (AttachableTarget)target;
            taskCommand = taskCommand + " " + Integer.toString(at.getPID());
        }
        String extraParams = this.getCollectorTaskExtraParams();
        this.isDeploymentTarget = target instanceof DLightDeploymentTarget;
        if (extraParams != null && target instanceof DLightDeploymentTarget) {
            DLightDeploymentTarget deploymentTarget = (DLightDeploymentTarget)target;
            Collection services = deploymentTarget.getDeploymentServices();
            for (DLightDeploymentService s : services) {
                String paramToReplace = "@" + s.getName();
                if (!extraParams.contains(paramToReplace)) continue;
                int pid = deploymentTarget.getPid(s);
                if (pid < 0) {
                    return;
                }
                extraParams = extraParams.replaceAll("@" + s.getName(), "" + pid);
            }
        }
        if (extraParams != null) {
            taskCommand = taskCommand + " " + extraParams;
        }
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)target.getExecEnv());
        npb.setCommandLine(taskCommand);
        this.dtraceRunner = new CollectorRunner((IndicatorNotificationsListener)new FakeIndicatorNotificationListener(), npb, this.getOutputProcessor(), "__EOF_MARKER__", "DTrace");
        log.fine("DtraceDataCollector (" + this.dtraceRunner.toString() + ") for " + taskCommand + " STARTED");
    }

    public void addValidationListener(ValidationListener listener) {
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    public void removeValidationListener(ValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    void notifyStatusChanged(Validateable<DLightTarget> validatable, ValidationStatus oldStatus, ValidationStatus newStatus) {
        if (oldStatus.equals((Object)newStatus)) {
            return;
        }
        ValidationListener[] ll = this.validationListeners.toArray(new ValidationListener[0]);
        if (validatable == null) {
            validatable = this;
        }
        for (ValidationListener l : ll) {
            l.validationStateChanged(validatable, oldStatus, newStatus);
        }
    }

    protected void notifyStatusChanged(ValidationStatus oldStatus, ValidationStatus newStatus) {
        this.notifyStatusChanged((Validateable<DLightTarget>)this, oldStatus, newStatus);
    }

    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case RUNNING: {
                this.targetStarted(event.target);
                break;
            }
            case FAILED: {
                this.targetFinished(event.target);
                break;
            }
            case TERMINATED: {
                this.terminated = true;
                this.targetFinished(event.target);
                break;
            }
            case DONE: {
                this.targetFinished(event.target);
                break;
            }
            case STOPPED: {
                this.targetFinished(event.target);
                return;
            }
        }
        for (DtraceDataCollector ddc : this.slaveCollectors.values()) {
            ddc.targetStateChanged(event);
        }
    }

    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
    }

    private boolean needsBootstrap() {
        ServiceInfoDataStorage info = this.getServiceInfoDataStorage();
        if (info != null) {
            String mode = info.getValue("DTraceMode");
            if (mode == null || !mode.equals("tracing")) {
                return false;
            }
            String pattern = info.getValue("DTraceTracingPattern");
            return pattern != null && pattern.trim().length() != 0;
        }
        return false;
    }

    private File mergeScripts() {
        try {
            HashMap<String, URL> scriptsMap = new HashMap<String, URL>();
            for (Map.Entry<String, DtraceDataCollector> entry : this.slaveCollectors.entrySet()) {
                scriptsMap.put(entry.getKey(), entry.getValue().getLocalScriptUrl());
            }
            return DTraceScriptUtils.mergeScripts(scriptsMap, this.needsBootstrap());
        }
        catch (IOException ex) {
            DLightLogger.getLogger(DtraceDataCollector.class).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private class FakeIndicatorNotificationListener
    implements IndicatorNotificationsListener {
        private FakeIndicatorNotificationListener() {
        }

        public void reset() {
            DtraceDataCollector.this.resetIndicators();
        }

        public void suggestRepaint() {
            if (DtraceDataCollector.this.isDeploymentTarget && DtraceDataCollector.this.terminated) {
                return;
            }
            DtraceDataCollector.this.suggestIndicatorsRepaint();
        }

        public void updated(List<DataRow> data) {
            if (DtraceDataCollector.this.isDeploymentTarget && DtraceDataCollector.this.terminated) {
                return;
            }
            DtraceDataCollector.this.notifyIndicators(data);
        }
    }

    private class DemultiplexingLineProcessor
    implements LineProcessor {
        private DemultiplexingLineProcessor() {
        }

        public void processLine(String line) {
            DtraceDataCollector target = DtraceDataCollector.this.lastSlaveCollector;
            for (Map.Entry entry : DtraceDataCollector.this.slaveCollectors.entrySet()) {
                String prefix = (String)entry.getKey();
                if (!line.startsWith(prefix)) continue;
                line = line.substring(prefix.length());
                target = (DtraceDataCollector)((Object)entry.getValue());
                break;
            }
            if (target != null) {
                target.getOutputProcessor().processLine(line);
            }
            DtraceDataCollector.this.lastSlaveCollector = target;
        }

        public void reset() {
            for (Map.Entry entry : DtraceDataCollector.this.slaveCollectors.entrySet()) {
                ((DtraceDataCollector)((Object)entry.getValue())).getOutputProcessor().reset();
            }
        }

        public void close() {
            for (Map.Entry entry : DtraceDataCollector.this.slaveCollectors.entrySet()) {
                ((DtraceDataCollector)((Object)entry.getValue())).getOutputProcessor().close();
            }
            DtraceDataCollector.this.suggestIndicatorsRepaint();
        }
    }

    private final class DefaultLineProcessor
    implements LineProcessor {
        private DefaultLineProcessor() {
        }

        public void processLine(String line) {
            DataRow dataRow = DtraceDataCollector.this.parser.process(line);
            this.addDataRow(dataRow);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addDataRow(DataRow dataRow) {
            if (DtraceDataCollector.this.isDeploymentTarget && DtraceDataCollector.this.terminated) {
                return;
            }
            if (dataRow != null) {
                if (DtraceDataCollector.this.storage != null && DtraceDataCollector.this.tableMetaData != null) {
                    DtraceDataCollector.this.storage.addData(DtraceDataCollector.this.tableMetaData.getName(), Arrays.asList(dataRow));
                }
                List list = DtraceDataCollector.this.indicatorDataBuffer;
                synchronized (list) {
                    DtraceDataCollector.this.indicatorDataBuffer.add(dataRow);
                    if (DtraceDataCollector.this.indicatorDataBuffer.size() >= DtraceDataCollector.this.indicatorFiringFactor) {
                        if (DtraceDataCollector.this.isSlave) {
                            if (DtraceDataCollector.this.parentCollector != null) {
                                DtraceDataCollector.this.parentCollector.notifyIndicators(DtraceDataCollector.this.indicatorDataBuffer);
                            }
                        } else {
                            DtraceDataCollector.this.notifyIndicators(DtraceDataCollector.this.indicatorDataBuffer);
                        }
                        DtraceDataCollector.this.indicatorDataBuffer.clear();
                    }
                }
            }
        }

        public void reset() {
        }

        public void close() {
            DataRow dataRow = DtraceDataCollector.this.parser.processClose();
            this.addDataRow(dataRow);
            DtraceDataCollector.this.suggestIndicatorsRepaint();
        }
    }
}

