/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.SourceWizardPanel;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class AdditionalWizardPanel
extends JPanel {
    private final Map<DataObject, SourceData> sourceMap = Util.createWizardSourceMap();
    private final Set<DataObject> viewedSources = new HashSet<DataObject>(0);
    private JComponent additionalComponent = EMPTY_COMPONENT;
    private static final JLabel EMPTY_COMPONENT = new JLabel(Util.getString("TXT_HasNoAdditonal"));
    private JComboBox sourceCombo;
    private JLabel sourceLabel;

    private AdditionalWizardPanel() {
        this.initComponents();
        this.initA11Y();
        this.setComboModel(this.sourceMap);
    }

    private void initA11Y() {
        this.sourceLabel.setLabelFor(this.sourceCombo);
        this.sourceCombo.getAccessibleContext().setAccessibleDescription(Util.getString("ACS_sourceCombo"));
    }

    private void setComboModel(Map<DataObject, SourceData> sourceMap) {
        DataObject[] sources = sourceMap.keySet().toArray(new DataObject[0]);
        ArrayList<DataObject> nonEmptySources = new ArrayList<DataObject>();
        for (DataObject source : sources) {
            if (!sourceMap.get(source).getSupport().hasAdditionalCustomizer()) continue;
            nonEmptySources.add(source);
        }
        this.sourceCombo.setModel(new DefaultComboBoxModel<Object>(nonEmptySources.toArray()));
        Object selected = this.sourceCombo.getSelectedItem();
        this.updateAdditionalComponent((DataObject)selected);
    }

    Set<DataObject> getViewedSources() {
        return this.viewedSources;
    }

    Map<DataObject, SourceData> getSourceMap() {
        return this.sourceMap;
    }

    void setSourceMap(Map<DataObject, SourceData> sourceMap) {
        this.sourceMap.clear();
        this.sourceMap.putAll(sourceMap);
        this.setComboModel(sourceMap);
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceCombo = new JComboBox();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getBundle(AdditionalWizardPanel.class).getString("LBL_Source"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceLabel, gridBagConstraints);
        this.sourceCombo.setRenderer(new SourceWizardPanel.DataObjectListCellRenderer());
        this.sourceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalWizardPanel.this.sourceComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.add((Component)this.sourceCombo, gridBagConstraints);
    }

    private void sourceComboActionPerformed(ActionEvent evt) {
        Object selected = this.sourceCombo.getSelectedItem();
        this.updateAdditionalComponent((DataObject)selected);
    }

    private void updateAdditionalComponent(DataObject selected) {
        I18nSupport support = null;
        if (selected != null) {
            support = this.sourceMap.get(selected).getSupport();
        }
        this.additionalComponent.setVisible(false);
        this.remove(this.additionalComponent);
        if (support != null && support.hasAdditionalCustomizer()) {
            this.additionalComponent = support.getAdditionalCustomizer();
            this.additionalComponent.setVisible(true);
            this.viewedSources.add(selected);
        } else {
            this.additionalComponent = EMPTY_COMPONENT;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.additionalComponent, gridBagConstraints);
        this.revalidate();
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel {
        private final JLabel emptyLabel = new JLabel(Util.getString("TXT_HasNoAdditonal"));
        private transient AdditionalWizardPanel additionalPanel;

        Panel() {
            this.emptyLabel.setHorizontalAlignment(0);
            this.emptyLabel.setVerticalAlignment(0);
        }

        @Override
        protected Component createComponent() {
            JPanel panel = new JPanel();
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AdditionalWizardPanel.class).getString("ACS_AdditionalWizardPanel"));
            panel.putClientProperty("WizardPanel_contentSelectedIndex", 2);
            panel.setName(NbBundle.getBundle(this.getClass()).getString("TXT_ModifyAdditional"));
            panel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            panel.add((Component)this.getUI(), constraints);
            return panel;
        }

        @Override
        public void readSettings(I18nWizardDescriptor.Settings settings) {
            super.readSettings(settings);
            this.getUI().setSourceMap(this.getMap());
            JPanel panel = (JPanel)this.getComponent();
            if (Panel.hasAdditional(this.getMap())) {
                if (panel.isAncestorOf(this.emptyLabel)) {
                    panel.remove(this.emptyLabel);
                    GridBagConstraints constraints = new GridBagConstraints();
                    constraints.weightx = 1.0;
                    constraints.weighty = 1.0;
                    constraints.fill = 1;
                    panel.add((Component)this.getUI(), constraints);
                }
            } else if (panel.isAncestorOf(this.getUI())) {
                panel.remove(this.getUI());
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 1;
                panel.add((Component)this.emptyLabel, constraints);
            }
        }

        @Override
        public void storeSettings(I18nWizardDescriptor.Settings settings) {
            super.storeSettings(settings);
            Map<DataObject, SourceData> sourceMap = this.getUI().getSourceMap();
            for (DataObject viewedSource : this.getUI().getViewedSources()) {
                SourceData sourceData = sourceMap.get(viewedSource);
                for (Map.Entry<HardCodedString, I18nString> entry : sourceData.getStringMap().entrySet()) {
                    entry.setValue(sourceData.getSupport().getDefaultI18nString(entry.getKey()));
                }
            }
            this.getMap().clear();
            this.getMap().putAll(sourceMap);
        }

        public void doLongTimeChanges() {
            ProgressWizardPanel progressPanel = new ProgressWizardPanel(true);
            this.showProgressPanel(progressPanel);
            progressPanel.setMainText(NbBundle.getMessage(this.getClass(), (String)"LBL_AdditionalIn"));
            progressPanel.setMainProgress(0);
            Map<DataObject, SourceData> sourceMap = ((AdditionalWizardPanel)this.getComponent()).getSourceMap();
            Iterator<DataObject> it = ((AdditionalWizardPanel)this.getComponent()).getViewedSources().iterator();
            int i = 0;
            while (it.hasNext()) {
                DataObject source = it.next();
                SourceData sourceData = sourceMap.get(source);
                ClassPath cp = ClassPath.getClassPath((FileObject)source.getPrimaryFile(), (String)"classpath/source");
                progressPanel.setMainText(NbBundle.getMessage(this.getClass(), (String)"LBL_AdditionalIn") + " " + cp.getResourceName(source.getPrimaryFile(), '.', false));
                HardCodedString[] hcStrings = sourceData.getStringMap().keySet().toArray(new HardCodedString[0]);
                int j = 0;
                while (i < hcStrings.length) {
                    sourceData.getStringMap().put(hcStrings[j], sourceData.getSupport().getDefaultI18nString(hcStrings[j]));
                    ++j;
                }
                progressPanel.setMainProgress((int)((float)(i + 1) / (float)sourceMap.size() * 100.0f));
                ++i;
            }
        }

        private void showProgressPanel(ProgressWizardPanel progressPanel) {
            ((Container)this.getComponent()).remove(this.getUI());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            ((Container)this.getComponent()).add((Component)progressPanel, constraints);
            ((JComponent)this.getComponent()).revalidate();
            this.getComponent().repaint();
        }

        public void reset() {
            Container container = (Container)this.getComponent();
            if (!container.isAncestorOf(this.getUI())) {
                container.removeAll();
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.fill = 1;
                container.add((Component)this.getUI(), constraints);
            }
        }

        public HelpCtx getHelp() {
            return new HelpCtx("internation.wizard");
        }

        private static boolean hasAdditional(Map<DataObject, SourceData> sourceMap) {
            for (Map.Entry<DataObject, SourceData> entry : sourceMap.entrySet()) {
                if (!entry.getValue().getSupport().hasAdditionalCustomizer()) continue;
                return true;
            }
            return false;
        }

        private synchronized AdditionalWizardPanel getUI() {
            if (this.additionalPanel == null) {
                this.additionalPanel = new AdditionalWizardPanel();
            }
            return this.additionalPanel;
        }
    }
}

