/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.plugins.api;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class ServerProgress
implements ProgressObject {
    private Object server;
    private List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private DeploymentStatus status;
    public static final Command START_SERVER = new Command(25, "START SERVER");
    public static final Command STOP_SERVER = new Command(26, "STOP SERVER");

    public ServerProgress(Object object) {
        this.server = object;
        this.createRunningProgressEvent(CommandType.START, "");
    }

    public void setStatusStartRunning(String string) {
        this.notify(this.createRunningProgressEvent(START_SERVER, string));
    }

    public void setStatusStartFailed(String string) {
        this.notify(this.createFailedProgressEvent(START_SERVER, string));
    }

    public void setStatusStartCompleted(String string) {
        this.notify(this.createCompletedProgressEvent(START_SERVER, string));
    }

    public void setStatusStopRunning(String string) {
        this.notify(this.createRunningProgressEvent(STOP_SERVER, string));
    }

    public void setStatusStopFailed(String string) {
        this.notify(this.createFailedProgressEvent(STOP_SERVER, string));
    }

    public void setStatusStopCompleted(String string) {
        this.notify(this.createCompletedProgressEvent(CommandType.STOP, string));
    }

    protected void notify(ProgressEvent progressEvent) {
        for (ProgressListener progressListener : this.listeners) {
            progressListener.handleProgressEvent(progressEvent);
        }
    }

    protected DeploymentStatus createDeploymentStatus(final CommandType commandType, final String string, final StateType stateType) {
        return new DeploymentStatus(){

            public ActionType getAction() {
                return ActionType.EXECUTE;
            }

            public CommandType getCommand() {
                return commandType;
            }

            public String getMessage() {
                return string;
            }

            public StateType getState() {
                return stateType;
            }

            public boolean isCompleted() {
                return StateType.COMPLETED.equals(stateType);
            }

            public boolean isFailed() {
                return StateType.FAILED.equals(stateType);
            }

            public boolean isRunning() {
                return StateType.RUNNING.equals(stateType);
            }
        };
    }

    protected ProgressEvent createCompletedProgressEvent(CommandType commandType, String string) {
        this.status = this.createDeploymentStatus(commandType, string, StateType.COMPLETED);
        return new ProgressEvent(this.server, null, this.status);
    }

    protected ProgressEvent createFailedProgressEvent(CommandType commandType, String string) {
        this.status = this.createDeploymentStatus(commandType, string, StateType.FAILED);
        return new ProgressEvent(this.server, null, this.status);
    }

    protected ProgressEvent createRunningProgressEvent(CommandType commandType, String string) {
        this.status = this.createDeploymentStatus(commandType, string, StateType.RUNNING);
        return new ProgressEvent(this.server, null, this.status);
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.listeners.add(progressListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.listeners.remove(progressListener);
    }

    public boolean isCancelSupported() {
        return true;
    }

    public void cancel() throws OperationUnsupportedException {
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.status;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[0];
    }

    public static class Command
    extends CommandType {
        String commandString;

        public Command(int n, String string) {
            super(n);
            this.commandString = string;
        }

        public String toString() {
            return this.commandString;
        }
    }
}

