/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.modules.cnd.debugger.gdb.utils.FieldTokenizer;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.openide.util.NbBundle;

public class TypeInfo {
    public static final String ANONYMOUS_PREFIX = "<anonymous";
    public static final String NAME = "<name>";
    public static final String NO_DATA_FIELDS = "<No data fields>";
    public static final String SUPER_PREFIX = "<super";
    public static final String ANON_COUNT = "<anon-count>";
    private final GdbDebugger debugger;
    private String resolvedType;
    private String rawInfo;
    private Map<String, Object> map;
    private static final Map<String, Map<String, Object>> mcache = new HashMap<String, Map<String, Object>>();
    protected static final Logger log = Logger.getLogger("gdb.logger");
    private static final boolean disable_ti_cache = true;
    private static final boolean disable_map_cache = true;

    public static TypeInfo getTypeInfo(GdbDebugger debugger, AbstractVariable var) {
        String resolvedType;
        String rawInfo = var.getName().equals(NbBundle.getMessage(AbstractVariable.class, (String)"LBL_BaseClass")) ? debugger.requestBaseClassType(var.getType()) : debugger.requestSymbolTypeFromName(var.getFullName());
        log.fine("TI.getTypeInfo[rawInfo]: " + var.getType() + " ==> [" + rawInfo + "]");
        if (rawInfo != null && rawInfo.length() > 0) {
            int pos1 = (rawInfo = rawInfo.replace("\\n", "").trim()).indexOf(123);
            if (pos1 == -1) {
                resolvedType = rawInfo;
            } else {
                resolvedType = rawInfo.substring(0, pos1).trim();
                int pos2 = resolvedType.indexOf(" : ");
                if (pos2 != -1) {
                    resolvedType = resolvedType.substring(0, pos2);
                }
                if ((pos2 = GdbUtils.findMatchingCurly(rawInfo, pos1)) != -1) {
                    resolvedType = resolvedType + rawInfo.substring(pos2 + 1);
                }
            }
        } else {
            resolvedType = null;
        }
        return new TypeInfo(debugger, var.getType(), resolvedType, rawInfo);
    }

    public TypeInfo(GdbDebugger debugger, String vartype, String resolvedType, String rawInfo) {
        this.debugger = debugger;
        this.resolvedType = resolvedType;
        this.rawInfo = rawInfo;
        this.map = null;
    }

    public String getResolvedType(AbstractVariable var) {
        if (var instanceof GdbWatchVariable) {
            this.resolvedType = null;
            this.rawInfo = null;
            this.map = null;
        }
        if (this.resolvedType == null) {
            if (this.rawInfo == null) {
                this.rawInfo = this.debugger.requestSymbolTypeFromName(var.getFullName());
            }
            if (this.rawInfo != null) {
                this.rawInfo = this.rawInfo.replace("\\n", "").trim();
                int pos1 = this.rawInfo.indexOf(123);
                if (pos1 == -1) {
                    this.resolvedType = this.rawInfo;
                } else {
                    this.resolvedType = this.rawInfo.substring(0, pos1).trim();
                    int pos2 = this.resolvedType.indexOf(" : ");
                    if (pos2 != -1) {
                        this.resolvedType = this.resolvedType.substring(0, pos2);
                    }
                    if ((pos2 = GdbUtils.findMatchingCurly(this.rawInfo, pos1)) != -1) {
                        this.resolvedType = this.resolvedType + this.rawInfo.substring(pos2 + 1);
                    }
                }
            }
        }
        return this.resolvedType;
    }

    public String getDetailedType(AbstractVariable var) {
        if (this.rawInfo == null) {
            this.rawInfo = this.debugger.requestSymbolTypeFromName(var.getFullName());
        }
        return this.rawInfo;
    }

    public Map<String, Object> getMap() {
        if (this.map == null) {
            this.map = this.getCachedMap();
            if (this.map == null) {
                this.map = this.createMap();
            }
        }
        return this.map;
    }

    private Map<String, Object> getCachedMap() {
        if (this.resolvedType != null) {
            Map<String, Object> m = mcache.get(this.resolvedType);
            if (m != null) {
                log.fine("TI.getCachedMap: Got Map for " + this.resolvedType);
            }
            return m;
        }
        return null;
    }

    private Map<String, Object> createMap() {
        if (this.resolvedType != null) {
            Map<String, Object> m = this.createFieldMap();
            return m;
        }
        return null;
    }

    private Map<String, Object> createFieldMap() {
        Map<String, Object> m = new HashMap<String, Object>();
        int pos1 = this.rawInfo.indexOf(123);
        int pos2 = GdbUtils.findMatchingCurly(this.rawInfo, pos1);
        String fields = null;
        if (pos1 != -1) {
            int pos0 = TypeInfo.getSuperclassColon(this.rawInfo.substring(0, pos1));
            if (pos0 != -1) {
                m = TypeInfo.addSuperclassEntries(m, this.rawInfo.substring(pos0 + 1, pos1));
            }
            String n = pos0 == -1 ? this.rawInfo.substring(0, pos1).trim() : this.rawInfo.substring(0, pos0).trim();
            m.put(NAME, n.startsWith("class ") ? n.substring(5).trim() : n);
        }
        String ri = this.rawInfo;
        if (pos1 == -1 && pos2 == -1) {
            if (GdbUtils.isPointer(this.rawInfo)) {
                ri = ri.replace('*', ' ').trim();
            }
        } else if (pos1 != -1 && pos2 != -1 && pos2 > pos1 + 1) {
            fields = ri.substring(pos1 + 1, pos2);
        }
        if (fields != null && (m = TypeInfo.parseFields(m, TypeInfo.shortenType(this.resolvedType), fields)).isEmpty()) {
            m.put("<" + ri.substring(0, pos1) + ">", NO_DATA_FIELDS);
        }
        return m;
    }

    private static int getSuperclassColon(String info) {
        char lastc = '\u0000';
        for (int i = 0; i < info.length(); ++i) {
            char nextc;
            char ch = info.charAt(i);
            char c = nextc = i + 1 < info.length() ? info.charAt(i + 1) : (char)'\u0000';
            if (ch == ':' && nextc != ':' && lastc != ':') {
                return i;
            }
            if (ch == '<') {
                i = GdbUtils.findMatchingLtGt(info, i);
            }
            lastc = ch;
        }
        return -1;
    }

    private static Map<String, Object> addSuperclassEntries(Map<String, Object> m, String info) {
        int start = 0;
        int scount = 1;
        for (int i = 0; i < info.length(); ++i) {
            if (info.substring(i).startsWith("public ")) {
                start = i += 7;
            } else if (info.substring(i).startsWith("private ")) {
                start = i += 8;
            } else if (info.substring(i).startsWith("protected ")) {
                start = i += 10;
            }
            if (i >= info.length()) continue;
            char c = info.charAt(i);
            if (c == '<') {
                int pos = GdbUtils.findMatchingLtGt(info, i);
                if (pos == -1) continue;
                i = pos;
                continue;
            }
            if (c != ',') continue;
            m.put(SUPER_PREFIX + scount++ + ">", info.substring(start, i).trim());
            if (i + 1 >= info.length()) continue;
            info = info.substring(i + 1);
            i = 0;
            start = 0;
        }
        m.put(SUPER_PREFIX + scount++ + ">", info.substring(start).trim());
        return m;
    }

    private static Map<String, Object> parseFields(Map<String, Object> m, String name, String info) {
        if (info != null) {
            if (m.get(NAME) == null) {
                m.put(NAME, name);
            }
            FieldTokenizer tok = new FieldTokenizer(info);
            while (tok.hasMoreFields()) {
                int pos;
                String[] field = tok.nextField();
                if (field[0] == null) continue;
                if (TypeInfo.isNonAnonymousCSUDef(field)) {
                    pos = field[0].indexOf(123);
                    int pos2 = field[0].lastIndexOf(125);
                    HashMap<String, Object> m2 = new HashMap<String, Object>();
                    m = TypeInfo.parseFields(m2, TypeInfo.shortenType(field[0]), field[0].substring(pos + 1, pos2).trim());
                    m.put(field[1], m2);
                    continue;
                }
                if (field[1].startsWith(ANONYMOUS_PREFIX) || field[0].endsWith("}")) {
                    pos = field[0].indexOf(123);
                    String frag = field[0].substring(pos + 1, field[0].length() - 1).trim();
                    Map<String, Object> m2 = TypeInfo.parseFields(new HashMap<String, Object>(), TypeInfo.shortenType(field[0]), frag);
                    m.put(field[1], m2);
                    continue;
                }
                pos = field[1].indexOf(91);
                if (pos == -1) {
                    m.put(field[1], field[0]);
                    continue;
                }
                m.put(field[1].substring(0, pos), field[0] + field[1].substring(pos));
            }
        }
        return m;
    }

    private static String shortenType(String type) {
        if (type.startsWith("class ")) {
            return type.charAt(6) == '{' ? "class {...}" : type.substring(6);
        }
        if (type.startsWith("struct ")) {
            return type.charAt(7) == '{' ? "struct {...}" : type.substring(7);
        }
        if (type.startsWith("union {")) {
            return type.charAt(6) == '{' ? "union {...}" : type.substring(6);
        }
        return type;
    }

    private static boolean isNonAnonymousCSUDef(String[] field) {
        String info = field[0];
        if (!field[1].startsWith(ANONYMOUS_PREFIX) && (info.startsWith("class {") || info.startsWith("struct {") || info.startsWith("union {"))) {
            int start = info.indexOf(123);
            int end = GdbUtils.findMatchingCurly(info, start) + 1;
            if (start != -1 && end != 0 && !info.substring(start, end).equals("{...}") && end != info.length()) {
                return true;
            }
        }
        return false;
    }
}

