/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.debugger.common.CallStackFrame;
import org.netbeans.modules.cnd.debugger.common.utils.Autos;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbLocalVariable;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;

public class GdbCallStackFrame
extends CallStackFrame {
    public static final boolean enableMacros = Boolean.getBoolean("gdb.autos.macros");
    private final GdbDebugger debugger;
    private final int lineNumber;
    private final String func;
    private final String file;
    private final String fullname;
    private final String resolvedName;
    private final int frameNumber;
    private final String address;
    private final String from;
    private AbstractVariable[] cachedLocalVariables = null;
    private AbstractVariable[] cachedAutos = null;
    private final String LOCALS_LOCK = new String("Locals lock");
    private final String AUTOS_LOCK = new String("Autos lock");
    private volatile boolean destroyed = false;
    private Collection<GdbVariable> arguments = null;
    private StyledDocument document = null;
    private int offset = -1;
    private final LocalsBuilder localsBuilder = new LocalsBuilder();
    private final AutosBuilder autosBuilder = new AutosBuilder();

    public GdbCallStackFrame(GdbDebugger debugger, String func, String file, String fullname, String lnum, String address, int frameNumber, String from) {
        this.debugger = debugger;
        this.func = func;
        this.file = file;
        this.fullname = fullname;
        this.resolvedName = fullname != null ? debugger.getPathMap().getLocalPath(debugger.getOSPath(fullname)) : null;
        this.address = address;
        this.frameNumber = frameNumber;
        this.from = from;
        int lNumber = -1;
        if (lnum != null) {
            try {
                lNumber = Integer.parseInt(lnum);
            }
            catch (NumberFormatException ex) {
                lNumber = 1;
            }
        } else {
            lNumber = -1;
        }
        this.lineNumber = lNumber;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFunctionName() {
        return this.func;
    }

    public String getFrom() {
        return this.from;
    }

    public String getFileName() {
        return this.file;
    }

    public String getFullname() {
        return this.resolvedName;
    }

    public String getOriginalFullName() {
        return this.fullname;
    }

    public String getAddr() {
        return this.address;
    }

    public void makeCurrent() {
        this.debugger.setCurrentCallStackFrame(this);
    }

    public boolean isValid() {
        return this.getFileName() != null && this.getOriginalFullName() != null && this.getFunctionName() != null;
    }

    public void popFrame() {
        this.debugger.getGdbProxy().exec_finish();
    }

    public Collection<GdbVariable> getArguments() {
        return this.arguments;
    }

    public void setArguments(Collection<GdbVariable> arguments) {
        this.arguments = arguments;
    }

    public StyledDocument getDocument() {
        File docFile;
        if (this.document == null && this.resolvedName != null && this.resolvedName.length() > 0 && (docFile = new File(this.resolvedName)).exists()) {
            FileObject fo = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)docFile));
            this.document = (StyledDocument)CsmUtilities.getDocument((FileObject)fo);
        }
        return this.document;
    }

    public int getOffset() {
        if (this.offset < 0 && this.lineNumber >= 0 && this.getDocument() != null) {
            this.offset = NbDocument.findLineOffset((StyledDocument)this.document, (int)(this.lineNumber - 1));
        }
        return this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractVariable[] getLocalVariables() {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        assert (!SwingUtilities.isEventDispatchThread());
        if (this.destroyed) {
            return new AbstractVariable[0];
        }
        AbstractVariable[] curLocals = this.localsBuilder.get();
        String string = this.LOCALS_LOCK;
        synchronized (string) {
            if (this.destroyed) {
                this.destroyVars(curLocals);
                this.cachedLocalVariables = null;
                return new AbstractVariable[0];
            }
            this.cachedLocalVariables = curLocals;
        }
        return this.cachedLocalVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractVariable[] getAutos() {
        if (this.destroyed) {
            return new AbstractVariable[0];
        }
        AbstractVariable[] curAutos = this.autosBuilder.get();
        String string = this.AUTOS_LOCK;
        synchronized (string) {
            if (this.destroyed) {
                this.destroyVars(curAutos);
                this.cachedAutos = null;
                return new AbstractVariable[0];
            }
            this.cachedAutos = curAutos;
        }
        return this.cachedAutos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        AbstractVariable[] curAutos;
        AbstractVariable[] curLocals;
        this.destroyed = true;
        String string = this.LOCALS_LOCK;
        synchronized (string) {
            curLocals = this.cachedLocalVariables;
            this.cachedLocalVariables = null;
        }
        this.destroyVars(curLocals);
        String string2 = this.AUTOS_LOCK;
        synchronized (string2) {
            curAutos = this.cachedAutos;
            this.cachedAutos = null;
        }
        this.destroyVars(curAutos);
    }

    private void destroyVars(AbstractVariable[] cache) {
        if (cache != null) {
            for (AbstractVariable var : cache) {
                if (var == null) continue;
                var.destroy();
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    private final class AutosBuilder {
        private AbstractVariable[] autos = null;

        private AutosBuilder() {
        }

        public synchronized AbstractVariable[] get() {
            if (this.autos == null) {
                Set res = Autos.get((StyledDocument)GdbCallStackFrame.this.getDocument(), (int)(GdbCallStackFrame.this.lineNumber - 1));
                this.autos = new AbstractVariable[res.size()];
                int i = 0;
                for (String name : res) {
                    if (GdbCallStackFrame.this.destroyed) break;
                    this.autos[i++] = new GdbLocalVariable(GdbCallStackFrame.this.debugger, name);
                }
            }
            return this.autos;
        }
    }

    private final class LocalsBuilder {
        private AbstractVariable[] locals = null;

        private LocalsBuilder() {
        }

        public synchronized AbstractVariable[] get() {
            if (this.locals == null) {
                List<GdbVariable> list = GdbCallStackFrame.this.debugger.getLocalVariables();
                this.locals = new AbstractVariable[list.size()];
                int i = 0;
                for (GdbVariable var : list) {
                    if (GdbCallStackFrame.this.destroyed) break;
                    this.locals[i++] = new GdbLocalVariable(GdbCallStackFrame.this.debugger, var);
                }
            }
            return this.locals;
        }
    }
}

