/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.evaluation.value.Category1Value;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TopValue;
import proguard.evaluation.value.Value;

public class Stack {
    private static final TopValue TOP_VALUE = new TopValue();
    protected Value[] values;
    protected int currentSize;
    protected int actualMaxSize;

    public Stack(int n) {
        this.values = new Value[n];
    }

    public Stack(Stack stack) {
        this(stack.values.length);
        this.copy(stack);
    }

    public int getActualMaxSize() {
        return this.actualMaxSize;
    }

    public void reset(int n) {
        if (n > this.values.length) {
            this.values = new Value[n];
        }
        this.clear();
        this.actualMaxSize = 0;
    }

    public void copy(Stack stack) {
        if (stack.values.length > this.values.length) {
            this.values = new Value[stack.values.length];
        }
        System.arraycopy(stack.values, 0, this.values, 0, stack.currentSize);
        this.currentSize = stack.currentSize;
        this.actualMaxSize = stack.actualMaxSize;
    }

    public boolean generalize(Stack stack) {
        if (this.currentSize != stack.currentSize) {
            throw new IllegalArgumentException("Stacks have different current sizes [" + this.currentSize + "] and [" + stack.currentSize + "]");
        }
        boolean bl = false;
        for (int i = 0; i < this.currentSize; ++i) {
            Value value = this.values[i];
            if (value == null) continue;
            Value value2 = null;
            Value value3 = stack.values[i];
            if (value3 != null) {
                value2 = value.generalize(value3);
            }
            bl = bl || !value.equals(value2);
            this.values[i] = value2;
        }
        if (this.actualMaxSize < stack.actualMaxSize) {
            this.actualMaxSize = stack.actualMaxSize;
        }
        return bl;
    }

    public void clear() {
        for (int i = 0; i < this.currentSize; ++i) {
            this.values[i] = null;
        }
        this.currentSize = 0;
    }

    public int size() {
        return this.currentSize;
    }

    public Value getBottom(int n) {
        return this.values[n];
    }

    public void setBottom(int n, Value value) {
        this.values[n] = value;
    }

    public Value getTop(int n) {
        return this.values[this.currentSize - n - 1];
    }

    public void setTop(int n, Value value) {
        this.values[this.currentSize - n - 1] = value;
    }

    public void removeTop(int n) {
        System.arraycopy(this.values, this.currentSize - n, this.values, this.currentSize - n - 1, n);
        --this.currentSize;
    }

    public void push(Value value) {
        if (value.isCategory2()) {
            this.values[this.currentSize++] = TOP_VALUE;
        }
        this.values[this.currentSize++] = value;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public Value pop() {
        Value value = this.values[--this.currentSize];
        this.values[this.currentSize] = null;
        if (value.isCategory2()) {
            this.values[--this.currentSize] = null;
        }
        return value;
    }

    public IntegerValue ipop() {
        return this.pop().integerValue();
    }

    public LongValue lpop() {
        return this.pop().longValue();
    }

    public FloatValue fpop() {
        return this.pop().floatValue();
    }

    public DoubleValue dpop() {
        return this.pop().doubleValue();
    }

    public ReferenceValue apop() {
        return this.pop().referenceValue();
    }

    public InstructionOffsetValue opop() {
        return this.pop().instructionOffsetValue();
    }

    public void pop1() {
        this.values[--this.currentSize] = null;
    }

    public void pop2() {
        this.values[--this.currentSize] = null;
        this.values[--this.currentSize] = null;
    }

    public void dup() {
        this.values[this.currentSize] = this.values[this.currentSize - 1].category1Value();
        ++this.currentSize;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void dup_x1() {
        this.values[this.currentSize] = this.values[this.currentSize - 1].category1Value();
        this.values[this.currentSize - 1] = this.values[this.currentSize - 2].category1Value();
        this.values[this.currentSize - 2] = this.values[this.currentSize];
        ++this.currentSize;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void dup_x2() {
        this.values[this.currentSize] = this.values[this.currentSize - 1].category1Value();
        this.values[this.currentSize - 1] = this.values[this.currentSize - 2];
        this.values[this.currentSize - 2] = this.values[this.currentSize - 3];
        this.values[this.currentSize - 3] = this.values[this.currentSize];
        ++this.currentSize;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void dup2() {
        this.values[this.currentSize] = this.values[this.currentSize - 2];
        this.values[this.currentSize + 1] = this.values[this.currentSize - 1];
        this.currentSize += 2;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void dup2_x1() {
        this.values[this.currentSize + 1] = this.values[this.currentSize - 1];
        this.values[this.currentSize] = this.values[this.currentSize - 2];
        this.values[this.currentSize - 1] = this.values[this.currentSize - 3];
        this.values[this.currentSize - 2] = this.values[this.currentSize + 1];
        this.values[this.currentSize - 3] = this.values[this.currentSize];
        this.currentSize += 2;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void dup2_x2() {
        this.values[this.currentSize + 1] = this.values[this.currentSize - 1];
        this.values[this.currentSize] = this.values[this.currentSize - 2];
        this.values[this.currentSize - 1] = this.values[this.currentSize - 3];
        this.values[this.currentSize - 2] = this.values[this.currentSize - 4];
        this.values[this.currentSize - 3] = this.values[this.currentSize + 1];
        this.values[this.currentSize - 4] = this.values[this.currentSize];
        this.currentSize += 2;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void swap() {
        Category1Value category1Value = this.values[this.currentSize - 1].category1Value();
        Category1Value category1Value2 = this.values[this.currentSize - 2].category1Value();
        this.values[this.currentSize - 1] = category1Value2;
        this.values[this.currentSize - 2] = category1Value;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Stack stack = (Stack)object;
        if (this.currentSize != stack.currentSize) {
            return false;
        }
        for (int i = 0; i < this.currentSize; ++i) {
            Value value = this.values[i];
            Value value2 = stack.values[i];
            if (!(value == null ? value2 != null : !value.equals(value2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.currentSize;
        for (int i = 0; i < this.currentSize; ++i) {
            Value value = this.values[i];
            if (value == null) continue;
            n ^= value.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.currentSize; ++i) {
            Value value = this.values[i];
            stringBuffer = stringBuffer.append('[').append(value == null ? "empty" : value.toString()).append(']');
        }
        return stringBuffer.toString();
    }
}

