/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.diff.DiffNode;
import org.netbeans.modules.mercurial.ui.diff.DiffStreamSource;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.openide.util.NbBundle;

public final class Setup
extends AbstractDiffSetup {
    public static final int DIFFTYPE_LOCAL = 0;
    public static final int DIFFTYPE_REMOTE = 1;
    public static final int DIFFTYPE_ALL = 2;
    public static final String REVISION_PRISTINE = "PRISTINE";
    public static final String REVISION_BASE = "BASE";
    public static final String REVISION_CURRENT = "LOCAL";
    public static final String REVISION_HEAD = "HEAD";
    private final File baseFile;
    private final String propertyName;
    private final String firstRevision;
    private final String secondRevision;
    private FileInformation info;
    private DiffStreamSource firstSource;
    private DiffStreamSource secondSource;
    private DiffController view;
    private DiffNode node;
    private String title;

    public Setup(File baseFile, String propertyName, int type) {
        String secondTitle;
        String firstTitle;
        this.baseFile = baseFile;
        this.propertyName = propertyName;
        this.info = Mercurial.getInstance().getFileStatusCache().getStatus(baseFile);
        int status = this.info.getStatus();
        ResourceBundle loc = NbBundle.getBundle(Setup.class);
        switch (type) {
            case 0: {
                if (Setup.match(status, 4100)) {
                    this.firstRevision = REVISION_BASE;
                    firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                    break;
                }
                if (Setup.match(status, 512)) {
                    this.firstRevision = null;
                    firstTitle = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(status, 2304)) {
                    this.firstRevision = REVISION_BASE;
                    firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                    break;
                }
                this.firstRevision = REVISION_BASE;
                firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_BaseRevision"), this.firstRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + type);
            }
        }
        switch (type) {
            case 0: {
                if (Setup.match(status, 64)) {
                    this.secondRevision = REVISION_CURRENT;
                    secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_LocalConflict"), this.secondRevision);
                    break;
                }
                if (Setup.match(status, 4100)) {
                    this.secondRevision = REVISION_CURRENT;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (Setup.match(status, 512)) {
                    this.secondRevision = null;
                    secondTitle = NbBundle.getMessage(Setup.class, (String)"LBL_Diff_NoLocalFile");
                    break;
                }
                if (Setup.match(status, 2304)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalDeleted");
                    break;
                }
                this.secondRevision = REVISION_CURRENT;
                secondTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_LocalModified"), this.secondRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow diff type: " + type);
            }
        }
        this.firstSource = new DiffStreamSource(baseFile, this.firstRevision, firstTitle);
        this.secondSource = new DiffStreamSource(baseFile, this.secondRevision, secondTitle);
        this.title = "<html>" + Mercurial.getInstance().getMercurialAnnotator().annotateNameHtml(baseFile, this.info);
    }

    public Setup(File baseFile, String firstRevision, String secondRevision, final boolean forceNonEditable) {
        this.baseFile = baseFile;
        this.propertyName = null;
        this.firstRevision = firstRevision;
        this.secondRevision = secondRevision;
        this.firstSource = new DiffStreamSource(baseFile, firstRevision, firstRevision);
        this.secondSource = new DiffStreamSource(baseFile, secondRevision, secondRevision){

            @Override
            public boolean isEditable() {
                return !forceNonEditable && super.isEditable();
            }
        };
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public FileInformation getInfo() {
        return this.info;
    }

    public void setView(DiffController view) {
        this.view = view;
    }

    public DiffController getView() {
        return this.view;
    }

    public StreamSource getFirstSource() {
        return this.firstSource;
    }

    public StreamSource getSecondSource() {
        return this.secondSource;
    }

    void setNode(DiffNode node) {
        this.node = node;
    }

    DiffNode getNode() {
        return this.node;
    }

    public String toString() {
        return this.title;
    }

    void initSources() throws IOException {
        if (this.firstSource != null) {
            this.firstSource.init();
        }
        if (this.secondSource != null) {
            this.secondSource.init();
        }
    }

    private static boolean match(int status, int mask) {
        return (status & mask) != 0;
    }
}

