/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.Util;

public abstract class TreeData
extends TreeChild {
    public static final String PROP_DATA = "data";
    private String data;

    protected TreeData(String data) throws InvalidArgumentException {
        this.checkData(data);
        this.data = data;
    }

    protected TreeData(TreeData data) {
        super(data);
        this.data = data.data;
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeData peer = (TreeData)object;
        return Util.equals(this.getData(), peer.getData());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeData peer = (TreeData)treeObject;
        try {
            this.setDataImpl(peer.getData());
        }
        catch (Exception exc) {
            throw new CannotMergeException(treeObject, exc);
        }
    }

    public final String getData() {
        return this.data;
    }

    private final void setDataImpl(String newData) {
        String oldData = this.data;
        this.data = newData;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeData::setDataImpl: firing data change " + oldData + " => " + newData);
        }
        this.firePropertyChange(PROP_DATA, oldData, newData);
    }

    public final void setData(String newData) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.data, newData)) {
            return;
        }
        this.checkReadOnly();
        this.checkData(newData);
        this.setDataImpl(newData);
    }

    protected abstract void checkData(String var1) throws InvalidArgumentException;

    public final int getLength() {
        return this.data.length();
    }

    public final String substringData(int offset, int count) throws InvalidArgumentException {
        try {
            return this.data.substring(offset, offset + count);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidArgumentException(ex);
        }
    }

    public final void appendData(String appData) throws ReadOnlyException, InvalidArgumentException {
        this.setData(this.data + appData);
    }

    public final void insertData(int offset, String inData) throws ReadOnlyException, InvalidArgumentException {
        this.checkReadOnly();
        try {
            String preData = this.data.substring(0, offset);
            String postData = this.data.substring(offset, this.data.length());
            this.setData(preData + inData + postData);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidArgumentException(ex);
        }
    }

    public final void deleteData(int offset, int count) throws ReadOnlyException, InvalidArgumentException {
        this.checkReadOnly();
        try {
            String preData = this.data.substring(0, offset);
            String postData = this.data.substring(offset + count, this.data.length());
            this.setData(preData + postData);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidArgumentException(ex);
        }
    }

    public final void replaceData(int offset, int count, String repData) throws ReadOnlyException, InvalidArgumentException {
        this.checkReadOnly();
        try {
            String preData = this.data.substring(0, offset);
            String postData = this.data.substring(offset + count, this.data.length());
            this.setData(preData + repData + postData);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidArgumentException(ex);
        }
    }

    public final TreeData splitData(int offset) throws ReadOnlyException, InvalidArgumentException {
        TreeData splitedData;
        this.checkReadOnly();
        try {
            String preData = this.data.substring(0, offset);
            String postData = this.data.substring(offset, this.data.length());
            splitedData = this.createData(preData);
            this.setData(postData);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidArgumentException(ex);
        }
        return splitedData;
    }

    protected abstract TreeData createData(String var1) throws InvalidArgumentException;

    public final boolean onlyWhiteSpaces() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeData::onlyWhiteSpaces: data = '" + this.data + "'");
        }
        String trimed = this.data.trim();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("        ::onlyWhiteSpaces: trimed = '" + trimed + "'");
        }
        return trimed.length() == 0;
    }
}

