/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.model;

import java.awt.Color;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import org.netbeans.modules.css.visual.model.CssProperties;
import org.netbeans.modules.css.visual.model.Utils;

public class ColorModel {
    private Color color = Color.BLACK;
    private Map colorNameHexMap = CssProperties.getColorNameHexMap();

    public DefaultComboBoxModel getColorList() {
        return new ColorList();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color newColor) {
        this.color = newColor;
    }

    public void setColor(String newColor) {
        this.setColor(Color.BLACK);
        if (newColor.startsWith(Utils.NOT_SET)) {
            return;
        }
        if (newColor.startsWith("#")) {
            this.setHexColor(newColor);
        } else if (newColor.startsWith("rgb")) {
            try {
                String rgbString = newColor.substring(newColor.indexOf("(") + 1, newColor.indexOf(")"));
                StringTokenizer st = new StringTokenizer(rgbString, ",");
                int red = Integer.parseInt(st.nextToken().trim());
                int green = Integer.parseInt(st.nextToken().trim());
                int blue = Integer.parseInt(st.nextToken().trim());
                this.color = new Color(red, green, blue);
            }
            catch (Exception exc) {
                this.color = Color.BLACK;
            }
        } else {
            String hexValue = (String)this.colorNameHexMap.get(newColor);
            if (hexValue != null) {
                this.setHexColor(hexValue);
            }
        }
    }

    public void setHexColor(String hexColor) {
        int start = 0;
        if (hexColor.startsWith("#")) {
            start = 1;
        }
        try {
            int red = Integer.parseInt(hexColor.substring(start, start + 2), 16);
            int green = Integer.parseInt(hexColor.substring(start + 2, start + 4), 16);
            int blue = Integer.parseInt(hexColor.substring(start + 4, start + 6), 16);
            this.color = new Color(red, green, blue);
        }
        catch (Exception exc) {
            this.color = Color.BLACK;
        }
    }

    public String getHexColor(Color col) {
        this.color = col;
        return this.getHexColor();
    }

    public String getHexColor() {
        String blueHex;
        String greenHex;
        String redHex = Integer.toHexString(this.color.getRed());
        if (redHex.length() < 2) {
            redHex = "0" + redHex;
        }
        if ((greenHex = Integer.toHexString(this.color.getGreen())).length() < 2) {
            greenHex = "0" + greenHex;
        }
        if ((blueHex = Integer.toHexString(this.color.getBlue())).length() < 2) {
            blueHex = "0" + blueHex;
        }
        String hexString = "#" + redHex + greenHex + blueHex;
        return hexString;
    }

    public class ColorList
    extends DefaultComboBoxModel {
        public ColorList() {
            this.addElement(Utils.NOT_SET);
            Iterator iter = ColorModel.this.colorNameHexMap.keySet().iterator();
            while (iter.hasNext()) {
                this.addElement(iter.next());
            }
        }
    }
}

