/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.lib.editor.util.PriorityMutex;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DebugRepaintManager;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorTabExpander;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutCache;
import org.netbeans.modules.editor.lib2.view.TextLayoutView;
import org.netbeans.modules.editor.lib2.view.ViewUpdates;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public final class DocumentView
extends EditorBoxView<ParagraphView>
implements PropertyChangeListener,
ChangeListener {
    private static final Logger LOG = Logger.getLogger(DocumentView.class.getName());
    private static final Logger REPAINT_LOG = Logger.getLogger(DebugRepaintManager.class.getName());
    private static final int LAZY_CHILDREN_MIN_BATCH = 10;
    static final int MAX_NON_LAZY_REBUILD = 3;
    static final boolean REQUIRE_EDT = Boolean.getBoolean("org.netbeans.editor.linewrap.edt");
    static final char PRINTING_SPACE = '\u00b7';
    static final char PRINTING_TAB = '\u00bb';
    static final char PRINTING_NEWLINE = '\u00b6';
    static final char LINE_CONTINUATION = '\u21a9';
    private static final String MUTEX_CLIENT_PROPERTY = "foldHierarchyMutex";
    private PriorityMutex pMutex;
    private JTextComponent textComponent;
    private ViewUpdates viewUpdates;
    private TextLayoutCache textLayoutCache;
    private boolean incomingModification;
    private float width;
    private float height;
    private int visibleWidth;
    private int visibleHeight;
    private FontRenderContext fontRenderContext;
    private Font defaultFont;
    private boolean customFont;
    private float defaultLineHeight;
    private float defaultAscent;
    private float defaultUnderlineOffset;
    private float defaultUnderlineThickness;
    private float defaultStrikethroughOffset;
    private float defaultStrikethroughThickness;
    private float defaultCharWidth;
    private Color defaultForeground;
    private boolean customForeground;
    private Color defaultBackground;
    private boolean customBackground;
    private Color defaultLimitLine;
    private int defaultLimitLineWidth;
    private LineWrapType lineWrapType;
    private TextLayout newlineTextLayout;
    private TextLayout tabTextLayout;
    private TextLayout singleCharTabTextLayout;
    private TextLayout lineContinuationTextLayout;
    private TabExpander tabExpander;
    private LookupListener lookupListener;
    private JViewport listeningOnViewport;
    private boolean previewOnly;
    private Preferences prefs;
    private PreferenceChangeListener prefsListener;
    private Map<?, ?> renderingHints;
    private int lazyChildrenBatch = 10;
    private int lengthyAtomicEdit;

    public static DocumentView get(JTextComponent component) {
        View view;
        View rootView;
        TextUI textUI = component.getUI();
        if (textUI != null && (rootView = textUI.getRootView(component)) != null && rootView.getViewCount() > 0 && (view = rootView.getView(0)) instanceof DocumentView) {
            return (DocumentView)view;
        }
        return null;
    }

    public DocumentView(Element elem, boolean previewOnly) {
        super(elem);
        assert (elem != null) : "Expecting non-null element";
        this.previewOnly = previewOnly;
        this.tabExpander = new EditorTabExpander(this);
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (this.lineWrapType == null) {
            return 0.0f;
        }
        return super.getPreferredSpan(axis);
    }

    @Override
    protected void setMajorAxisSpan(double majorAxisSpan) {
        super.setMajorAxisSpan(majorAxisSpan);
    }

    @Override
    protected void setMinorAxisSpan(float minorAxisSpan) {
        super.setMinorAxisSpan(minorAxisSpan);
    }

    public PriorityMutex getMutex() {
        return this.pMutex;
    }

    @Override
    public Document getDocument() {
        return this.getElement().getDocument();
    }

    @Override
    public int getMajorAxis() {
        return 1;
    }

    @Override
    protected TabExpander getTabExpander() {
        return this.tabExpander;
    }

    @Override
    public int getRawOffset() {
        return 0;
    }

    @Override
    public void setRawOffset(int rawOffset) {
        throw new IllegalStateException("Unexpected");
    }

    @Override
    public void setSize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public Rectangle2D.Double getAllocation() {
        return new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
    }

    public float getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null) {
            Container container = this.getContainer();
            assert (container != null) : "Container is null";
            assert (container instanceof JTextComponent) : "Container not JTextComponent";
            this.textComponent = (JTextComponent)container;
            this.pMutex = (PriorityMutex)this.textComponent.getClientProperty(MUTEX_CLIENT_PROPERTY);
            if (this.pMutex == null) {
                this.pMutex = new PriorityMutex();
                this.textComponent.putClientProperty(MUTEX_CLIENT_PROPERTY, this.pMutex);
            }
            this.viewUpdates = new ViewUpdates(this);
            this.textLayoutCache = new TextLayoutCache();
            this.textComponent.addPropertyChangeListener(this);
            if (REPAINT_LOG.isLoggable(Level.FINE)) {
                DebugRepaintManager.register(this.textComponent);
            }
        } else {
            this.textComponent.removePropertyChangeListener(this);
            PriorityMutex mutex = this.getMutex();
            if (mutex != null) {
                mutex.lock();
                try {
                    this.textComponent = null;
                }
                finally {
                    mutex.unlock();
                }
            }
        }
    }

    void checkViewsInited() {
        Graphics graphics;
        if (this.children == null && this.textComponent != null && (graphics = this.textComponent.getGraphics()) != null) {
            assert (graphics instanceof Graphics2D) : "Not Graphics2D";
            this.updateVisibleDimension();
            this.checkSettingsInfo();
            if (this.renderingHints != null) {
                ((Graphics2D)graphics).setRenderingHints(this.renderingHints);
            }
            this.fontRenderContext = ((Graphics2D)graphics).getFontRenderContext();
            this.updateCharMetrics();
            this.reinitViews();
        }
    }

    @Override
    protected void releaseChildren(boolean resetSpans) {
        this.textLayoutCache.clear();
        super.releaseChildren(resetSpans);
    }

    public void reinitViews() {
        this.getDocument().render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PriorityMutex mutex = DocumentView.this.getMutex();
                if (mutex != null) {
                    mutex.lock();
                    try {
                        ((EditorTabExpander)DocumentView.this.tabExpander).updateTabSize();
                        if (DocumentView.this.fontRenderContext != null) {
                            DocumentView.this.viewUpdates.reinitViews();
                        }
                    }
                    finally {
                        mutex.unlock();
                    }
                }
            }
        });
    }

    @Override
    protected void initChildren(int startIndex, int endIndex) {
        this.viewUpdates.initChildren(startIndex, endIndex, this.lazyChildrenBatch);
    }

    private void updateLazyChildrenBatch() {
        if (this.defaultLineHeight > 0.0f) {
            this.lazyChildrenBatch = Math.max((int)((float)this.visibleHeight / this.defaultLineHeight + 2.0f), 10);
            LOG.log(Level.FINE, "lazyChildrenBatch={0}\n", this.lazyChildrenBatch);
        }
    }

    void recomputeSpans() {
        boolean widthChange;
        this.checkDocumentLocked();
        int viewCount = this.getViewCount();
        boolean heightChange = false;
        float origWidth = this.getMinorAxisSpan();
        float newWidth = 0.0f;
        for (int i = 0; i < viewCount; ++i) {
            boolean childWidthChange;
            ParagraphView paragraphView = (ParagraphView)this.getEditorView(i);
            double origChildWidth = paragraphView.getMajorAxisSpan();
            float origChildHeight = paragraphView.getMinorAxisSpan();
            paragraphView.recomputeSpans();
            double childWidth = paragraphView.getMajorAxisSpan();
            boolean bl = childWidthChange = origChildWidth != childWidth;
            if (childWidth > (double)newWidth) {
                newWidth = (float)childWidth;
            }
            boolean childHeightChange = origChildHeight != paragraphView.getMinorAxisSpan();
            heightChange |= childHeightChange;
            this.preferenceChanged(i, childWidthChange, childHeightChange, false);
        }
        boolean bl = widthChange = origWidth != newWidth;
        if (widthChange) {
            this.setMinorAxisSpan(newWidth);
        }
        if (widthChange || heightChange) {
            this.preferenceChanged(null, widthChange, heightChange);
        }
    }

    private void updateVisibleDimension() {
        boolean heightDiffers;
        Dimension newSize;
        Container parent = this.textComponent.getParent();
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            if (this.listeningOnViewport != viewport) {
                if (this.listeningOnViewport != null) {
                    this.listeningOnViewport.removeChangeListener(this);
                }
                viewport.addChangeListener(this);
                this.listeningOnViewport = viewport;
            }
            newSize = viewport.getExtentSize();
        } else {
            newSize = this.textComponent.getSize();
        }
        boolean widthDiffers = newSize.width != this.visibleWidth;
        boolean bl = heightDiffers = newSize.height != this.visibleHeight;
        if (widthDiffers) {
            this.visibleWidth = newSize.width;
        }
        if (heightDiffers) {
            this.visibleHeight = newSize.height;
        }
        if (heightDiffers) {
            this.updateLazyChildrenBatch();
        }
        if (widthDiffers) {
            this.recomputeSpans();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Document doc = this.getDocument();
        doc.render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PriorityMutex mutex = DocumentView.this.getMutex();
                if (mutex != null) {
                    mutex.lock();
                    try {
                        if (DocumentView.this.textComponent != null) {
                            DocumentView.this.updateVisibleDimension();
                        }
                    }
                    finally {
                        mutex.unlock();
                    }
                }
            }
        });
    }

    private void checkSettingsInfo() {
        String mimeType;
        if (this.textComponent == null) {
            return;
        }
        if (this.lookupListener == null) {
            this.lookupListener = new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    final Lookup.Result result = (Lookup.Result)ev.getSource();
                    DocumentView.this.getDocument().render(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            PriorityMutex mutex = DocumentView.this.getMutex();
                            if (mutex != null) {
                                mutex.lock();
                                try {
                                    if (DocumentView.this.textComponent != null) {
                                        DocumentView.this.updateDefaultFontAndColors((Lookup.Result<FontColorSettings>)result);
                                    }
                                }
                                finally {
                                    mutex.unlock();
                                }
                            }
                        }
                    });
                }
            };
            mimeType = DocumentUtilities.getMimeType((JTextComponent)this.textComponent);
            Lookup lookup = MimeLookup.getLookup((String)mimeType);
            Lookup.Result result = lookup.lookupResult(FontColorSettings.class);
            this.updateDefaultFontAndColors((Lookup.Result<FontColorSettings>)result);
            result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, (Object)result));
        }
        if (this.prefs == null) {
            mimeType = DocumentUtilities.getMimeType((JTextComponent)this.textComponent);
            this.prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
            this.prefsListener = new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    String key = evt.getKey();
                    if (key == null || key.equals("non-printable-characters-visible")) {
                        DocumentView.this.reinitViews();
                    }
                }
            };
            this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs));
        }
        if (this.lineWrapType == null) {
            Integer dllw;
            Document doc = this.getDocument();
            this.lineWrapType = LineWrapType.fromSettingValue((String)doc.getProperty("text-line-wrap"));
            if (this.lineWrapType == null) {
                this.lineWrapType = LineWrapType.NONE;
            }
            this.defaultLimitLineWidth = (dllw = (Integer)this.getDocument().getProperty("text-limit-width")) != null ? dllw : 80;
            DocumentUtilities.addPropertyChangeListener((Document)doc, (PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)doc));
        }
    }

    void updateDefaultFontAndColors(Lookup.Result<FontColorSettings> result) {
        Font font = this.textComponent.getFont();
        Color foreColor = this.textComponent.getForeground();
        Color backColor = this.textComponent.getBackground();
        Color limitLineColor = Color.PINK;
        if (result != null) {
            Color c;
            FontColorSettings fcs = (FontColorSettings)result.allInstances().iterator().next();
            AttributeSet attributes = fcs.getFontColors("default");
            if (attributes != null) {
                font = ViewUtils.getFont(attributes, font);
                c = (Color)attributes.getAttribute(StyleConstants.Foreground);
                if (c != null) {
                    foreColor = c;
                }
                if ((c = (Color)attributes.getAttribute(StyleConstants.Background)) != null) {
                    backColor = c;
                }
                this.renderingHints = (Map)attributes.getAttribute(EditorStyleConstants.RenderingHints);
            }
            if ((attributes = fcs.getFontColors("text-limit-line-color")) != null && (c = (Color)attributes.getAttribute(StyleConstants.Foreground)) != null) {
                limitLineColor = c;
            }
        }
        this.defaultFont = font;
        this.defaultForeground = foreColor;
        this.defaultBackground = backColor;
        this.defaultLimitLine = limitLineColor;
        if (!this.customFont) {
            this.textComponent.setFont(this.defaultFont);
        }
        if (!this.customForeground) {
            this.textComponent.setForeground(this.defaultForeground);
        }
        if (!this.customBackground) {
            this.textComponent.setBackground(this.defaultBackground);
        }
        this.updateCharMetrics();
        this.reinitViews();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.getDumpId() + ": Updated DEFAULTS: font=" + this.defaultFont + ", fg=" + ViewUtils.toString(this.defaultForeground) + ", bg=" + ViewUtils.toString(this.defaultBackground));
        }
    }

    private void updateCharMetrics() {
        FontRenderContext frc = this.getFontRenderContext();
        assert (this.defaultFont != null) : "Null defaultFont";
        if (frc != null) {
            char defaultChar = 'A';
            String defaultText = String.valueOf(defaultChar);
            TextLayout textLayout = new TextLayout(defaultText, this.defaultFont, frc);
            this.defaultLineHeight = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
            this.defaultLineHeight = ViewUtils.cutFractions(this.defaultLineHeight);
            this.defaultAscent = textLayout.getAscent();
            LineMetrics lineMetrics = this.defaultFont.getLineMetrics(defaultText, frc);
            this.defaultUnderlineOffset = lineMetrics.getUnderlineOffset();
            this.defaultUnderlineThickness = lineMetrics.getUnderlineThickness();
            this.defaultStrikethroughOffset = lineMetrics.getStrikethroughOffset();
            this.defaultStrikethroughThickness = lineMetrics.getStrikethroughThickness();
            this.defaultCharWidth = ViewUtils.cutFractions(textLayout.getAdvance());
            this.tabTextLayout = null;
            this.singleCharTabTextLayout = null;
            this.lineContinuationTextLayout = null;
            this.updateLazyChildrenBatch();
            if (LOG.isLoggable(Level.FINE)) {
                FontMetrics fm = this.textComponent.getFontMetrics(this.defaultFont);
                LOG.fine("Font: " + this.defaultFont + "\nLine-height=" + this.defaultLineHeight + ", ascent=" + textLayout.getAscent() + ", descent=" + textLayout.getDescent() + ", leading=" + textLayout.getLeading() + "\nChar-width=" + this.defaultCharWidth + ", underlineOffset=" + this.defaultUnderlineOffset + "\nFontMetrics (for comparison): fm-line-height=" + fm.getHeight() + ", fm-ascent=" + fm.getAscent() + ", fm-descent=" + fm.getDescent() + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, Shape alloc, Rectangle clipBounds) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                this.checkDocumentLocked();
                this.checkViewsInited();
                if (this.isActive()) {
                    if (this.renderingHints != null) {
                        g.setRenderingHints(this.renderingHints);
                    }
                    super.paint(g, alloc, clipBounds);
                }
            }
            finally {
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                this.checkDocumentLocked();
                this.checkViewsInited();
                if (this.isActive()) {
                    offset = super.getNextVisualPositionFromChecked(offset, bias, alloc, direction, biasRet);
                }
            }
            finally {
                mutex.unlock();
            }
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        Rectangle2D.Double rect = ViewUtils.shape2Bounds(alloc);
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                int index;
                this.checkDocumentLocked();
                this.checkViewsInited();
                if (this.isActive()) {
                    Shape shape = super.modelToViewChecked(offset, alloc, bias);
                    return shape;
                }
                if (this.children != null && (index = this.getViewIndexFirst(offset)) >= 0) {
                    rect.y = this.getViewVisualOffset(index);
                }
            }
            finally {
                mutex.unlock();
            }
        }
        if (this.defaultLineHeight > 0.0f) {
            rect.height = this.defaultLineHeight;
        }
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double modelToY(int offset, Shape alloc) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                int index;
                this.checkDocumentLocked();
                this.checkViewsInited();
                if (this.isActive() && (index = this.getViewIndexFirst(offset)) >= 0) {
                    double d = this.getViewVisualOffset(index);
                    return d;
                }
            }
            finally {
                mutex.unlock();
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                this.checkDocumentLocked();
                this.checkViewsInited();
                if (this.isActive()) {
                    int n = super.viewToModelChecked(x, y, alloc, biasReturn);
                    return n;
                }
            }
            finally {
                mutex.unlock();
            }
        }
        return 0;
    }

    void setIncomingModification(boolean incomingModification) {
        this.incomingModification = incomingModification;
    }

    boolean isActive() {
        return this.isUpdatable() && !this.incomingModification;
    }

    boolean isUpdatable() {
        return this.textComponent != null && this.children != null && this.lengthyAtomicEdit <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLengthyAtomicEdit(int delta) {
        PriorityMutex mutex;
        this.lengthyAtomicEdit += delta;
        if (this.lengthyAtomicEdit == 0 && (mutex = this.getMutex()) != null) {
            mutex.lock();
            try {
                this.checkDocumentLocked();
                this.releaseChildren(true);
            }
            finally {
                mutex.unlock();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt, Shape alloc, ViewFactory viewFactory) {
    }

    @Override
    public void removeUpdate(DocumentEvent evt, Shape alloc, ViewFactory viewFactory) {
    }

    @Override
    public void changedUpdate(DocumentEvent evt, Shape alloc, ViewFactory viewFactory) {
    }

    float getVisibleWidth() {
        return this.visibleWidth;
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    TextLayoutCache getTextLayoutCache() {
        return this.textLayoutCache;
    }

    @Override
    public TextLayout getTextLayout(TextLayoutView textLayoutView) {
        return null;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public float getDefaultLineHeight() {
        this.checkSettingsInfo();
        return this.defaultLineHeight;
    }

    public float getDefaultAscent() {
        this.checkSettingsInfo();
        return this.defaultAscent;
    }

    public float getDefaultUnderlineOffset() {
        this.checkSettingsInfo();
        return this.defaultUnderlineOffset;
    }

    public float getDefaultUnderlineThickness() {
        this.checkSettingsInfo();
        return this.defaultUnderlineThickness;
    }

    public float getDefaultStrikethroughOffset() {
        this.checkSettingsInfo();
        return this.defaultStrikethroughOffset;
    }

    public float getDefaultStrikethroughThickness() {
        this.checkSettingsInfo();
        return this.defaultStrikethroughThickness;
    }

    public float getDefaultCharWidth() {
        this.checkSettingsInfo();
        return this.defaultCharWidth;
    }

    public boolean isShowNonprintingCharacters() {
        this.checkSettingsInfo();
        return this.prefs.getBoolean("non-printable-characters-visible", false);
    }

    LineWrapType getLineWrapType() {
        this.checkSettingsInfo();
        return this.lineWrapType;
    }

    Color getTextLimitLineColor() {
        this.checkSettingsInfo();
        return this.defaultLimitLine;
    }

    boolean isTextLimitLineDrawn() {
        this.checkSettingsInfo();
        return this.prefs.getBoolean("text-limit-line-visible", true);
    }

    int getTextLimitWidth() {
        this.checkSettingsInfo();
        if (this.defaultLimitLineWidth > 0) {
            return this.defaultLimitLineWidth;
        }
        return this.prefs.getInt("text-limit-width", 80);
    }

    TextLayout getNewlineCharTextLayout() {
        if (this.newlineTextLayout == null) {
            this.newlineTextLayout = this.createTextLayout(String.valueOf('\u00b6'), this.defaultFont);
        }
        return this.newlineTextLayout;
    }

    TextLayout getTabCharTextLayout(double availableWidth) {
        if (this.tabTextLayout == null) {
            this.tabTextLayout = this.createTextLayout(String.valueOf('\u00bb'), this.defaultFont);
        }
        TextLayout ret = this.tabTextLayout;
        if (this.tabTextLayout != null && availableWidth > 0.0 && (double)this.tabTextLayout.getAdvance() > availableWidth) {
            if (this.singleCharTabTextLayout == null) {
                for (int i = this.defaultFont.getSize() - 1; i >= 0; --i) {
                    Font font = new Font(this.defaultFont.getName(), this.defaultFont.getStyle(), i);
                    this.singleCharTabTextLayout = this.createTextLayout(String.valueOf('\u00bb'), font);
                    if (this.singleCharTabTextLayout == null) break;
                    if (!(this.singleCharTabTextLayout.getAdvance() <= this.getDefaultCharWidth())) continue;
                    LOG.log(Level.FINE, "singleChar font size={0}\n", i);
                    break;
                }
            }
            ret = this.singleCharTabTextLayout;
        }
        return ret;
    }

    TextLayout getLineContinuationCharTextLayout() {
        if (this.lineContinuationTextLayout == null) {
            this.lineContinuationTextLayout = this.createTextLayout(String.valueOf('\u21a9'), this.defaultFont);
        }
        return this.lineContinuationTextLayout;
    }

    private TextLayout createTextLayout(String text, Font font) {
        this.checkSettingsInfo();
        if (this.fontRenderContext != null && font != null) {
            return new TextLayout(text, font, this.fontRenderContext);
        }
        return null;
    }

    void checkDocumentLocked() {
        if (LOG.isLoggable(Level.FINE) && !DocumentUtilities.isReadLocked((Document)this.getDocument())) {
            LOG.log(Level.INFO, "Document not locked", new Exception("Document not locked"));
        }
        if (REQUIRE_EDT && !SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Not in Event Dispatch Thread");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Document) {
            int llw;
            boolean reinitViews = false;
            String propName = evt.getPropertyName();
            if (propName == null || "text-line-wrap".equals(propName)) {
                LineWrapType lwt = LineWrapType.fromSettingValue((String)this.getDocument().getProperty("text-line-wrap"));
                if (lwt == null) {
                    lwt = LineWrapType.NONE;
                }
                if (lwt != this.lineWrapType) {
                    LOG.log(Level.FINE, "Changing lineWrapType from {0} to {1}", new Object[]{this.lineWrapType, lwt});
                    this.lineWrapType = lwt;
                    reinitViews = true;
                }
            }
            if (propName == null || "tab-size".equals(propName)) {
                reinitViews = true;
            }
            if ((propName == null || "text-limit-width".equals(propName)) && (llw = ((Integer)this.getDocument().getProperty("text-limit-width")).intValue()) != this.defaultLimitLineWidth) {
                LOG.log(Level.FINE, "Changing defaultLimitLineWidth from {0} to {1}", new Object[]{this.defaultLimitLineWidth, llw});
                this.defaultLimitLineWidth = llw;
                reinitViews = true;
            }
            if (reinitViews) {
                this.reinitViews();
            }
        } else {
            String propName = evt.getPropertyName();
            if ("ancestor".equals(propName)) {
                this.checkViewsInited();
            } else if ("font".equals(propName)) {
                if (!this.customFont && this.defaultFont != null) {
                    this.customFont = !this.defaultFont.equals(this.textComponent.getFont());
                }
            } else if ("foreground".equals(propName)) {
                if (!this.customForeground && this.defaultForeground != null) {
                    this.customForeground = !this.defaultForeground.equals(this.textComponent.getForeground());
                }
            } else if ("background".equals(propName) && !this.customBackground && this.defaultBackground != null) {
                this.customBackground = !this.defaultBackground.equals(this.textComponent.getBackground());
            }
        }
    }

    @Override
    protected String getDumpName() {
        return "DV";
    }

    @Override
    public String findIntegrityError() {
        Object lastView;
        Document doc;
        int docTextLength;
        int startOffset = this.getStartOffset();
        if (startOffset != 0) {
            return "Invalid startOffset=" + startOffset;
        }
        int endOffset = this.getEndOffset();
        if (endOffset != (docTextLength = (doc = this.getDocument()).getLength() + 1)) {
            return "Invalid endOffset=" + endOffset + ", docLen=" + doc.getLength();
        }
        int viewCount = this.getViewCount();
        if (viewCount > 0 && ((View)(lastView = this.getEditorView(viewCount - 1))).getEndOffset() != endOffset) {
            return "lastView.endOffset=" + ((View)lastView).getEndOffset() + " != endOffset=" + endOffset;
        }
        return null;
    }

    @Override
    public String findTreeIntegrityError() {
        final String[] ret = new String[1];
        this.getDocument().render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PriorityMutex mutex = DocumentView.this.getMutex();
                if (mutex != null) {
                    mutex.lock();
                    try {
                        ret[0] = DocumentView.super.findTreeIntegrityError();
                    }
                    finally {
                        mutex.unlock();
                    }
                }
            }
        });
        return ret[0];
    }

    @Override
    protected StringBuilder appendViewInfoCore(StringBuilder sb, int indent, int importantChildIndex) {
        super.appendViewInfoCore(sb, indent, importantChildIndex);
        sb.append("; incomingMod=").append(this.incomingModification);
        return sb;
    }

    @Override
    protected StringBuilder appendViewInfo(final StringBuilder sb, final int indent, final int importantChildIndex) {
        this.getDocument().render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PriorityMutex mutex = DocumentView.this.getMutex();
                if (mutex != null) {
                    mutex.lock();
                    try {
                        DocumentView.super.appendViewInfo(sb, indent, importantChildIndex);
                    }
                    finally {
                        mutex.unlock();
                    }
                }
            }
        });
        return sb;
    }

    static enum LineWrapType {
        NONE("none"),
        CHARACTER_BOUND("chars"),
        WORD_BOUND("words");

        private final String settingValue;

        private LineWrapType(String settingValue) {
            this.settingValue = settingValue;
        }

        public static LineWrapType fromSettingValue(String settingValue) {
            if (settingValue != null) {
                for (LineWrapType lwt : LineWrapType.values()) {
                    if (!lwt.settingValue.equals(settingValue)) continue;
                    return lwt;
                }
            }
            return null;
        }
    }
}

