/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.openide.util.NbBundle;

class HostsListTableModel
extends AbstractTableModel {
    private final ProgressHandle phandle;
    private short curr4;
    private boolean proceed;
    private boolean first = true;
    private Thread loaderThread;
    private Runnable runOnFinish;
    private static final Comparator<HostRecord> hrc = new Comparator<HostRecord>(){

        @Override
        public int compare(HostRecord o1, HostRecord o2) {
            if (o1.ssh && !o2.ssh) {
                return -1;
            }
            if (!o1.ssh && o2.ssh) {
                return 1;
            }
            return o1.name.compareTo(o2.name);
        }
    };
    private final List<HostRecord> rows = new ArrayList<HostRecord>();

    public HostsListTableModel() {
        this.phandle = ProgressHandleFactory.createHandle((String)"Gathering hosts information");
    }

    public ProgressHandle getProgressHandle() {
        return this.phandle;
    }

    public void start(Runnable runOnFinish) {
        assert (SwingUtilities.isEventDispatchThread()) : "should be called from EDT thread only";
        this.runOnFinish = runOnFinish;
        if (this.first) {
            this.first = false;
            this.phandle.start(255);
        }
        this.proceed = true;
        this.loaderThread = new Thread(new HostsLoader());
        this.loaderThread.start();
    }

    public void stop() {
        this.proceed = false;
        if (this.loaderThread != null) {
            this.loaderThread.interrupt();
        }
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        HostRecord record = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return record.name;
            }
            case 1: {
                return NbBundle.getMessage(this.getClass(), (String)(record.ssh ? "HostAvailable" : "HostUnavailable"));
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    public String getHostName(int row) {
        return this.rows.get((int)row).name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHost(String ip, String name, boolean ssh) {
        List<HostRecord> list = this.rows;
        synchronized (list) {
            HostRecord record = new HostRecord(ip, name, ssh);
            this.rows.add(record);
            Collections.sort(this.rows, hrc);
            this.fireTableDataChanged();
        }
    }

    private static boolean doPing(InetAddress addr, int port) {
        try {
            Socket socket = new Socket(addr, port);
            socket.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    static /* synthetic */ short access$208(HostsListTableModel x0) {
        short s = x0.curr4;
        x0.curr4 = (short)(s + 1);
        return s;
    }

    private class HostsLoader
    implements Runnable {
        private HostsLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RemoteUtil.LOGGER.fine("Hosts Lookup thread started");
            try {
                byte[] ip = InetAddress.getLocalHost().getAddress();
                if (ip.length < 4) {
                    return;
                }
                if (ip[0] == 127 && ip[1] == 0 && ip[2] == 0 && ip[3] == 1) {
                    return;
                }
                int idxLast = ip.length - 1;
                byte localLastOne = ip[idxLast];
                int hostCount = 0;
                while (HostsListTableModel.this.proceed && HostsListTableModel.this.curr4 <= 255) {
                    HostsListTableModel.this.phandle.progress((int)HostsListTableModel.this.curr4);
                    if (HostsListTableModel.this.curr4 != localLastOne) {
                        ip[idxLast] = (byte)HostsListTableModel.this.curr4;
                        InetAddress host = InetAddress.getByAddress(ip);
                        try {
                            if (host.isReachable(1000)) {
                                ++hostCount;
                                HostsListTableModel.this.addHost(host.getHostAddress(), host.getHostName(), HostsListTableModel.doPing(host, 22));
                            }
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    HostsListTableModel.access$208(HostsListTableModel.this);
                }
            }
            catch (UnknownHostException ex) {
                RemoteUtil.LOGGER.log(Level.WARNING, "Exception when filling hosts table", ex);
            }
            finally {
                if (HostsListTableModel.this.proceed) {
                    HostsListTableModel.this.phandle.finish();
                    if (HostsListTableModel.this.runOnFinish != null) {
                        SwingUtilities.invokeLater(HostsListTableModel.this.runOnFinish);
                    }
                    RemoteUtil.LOGGER.log(Level.FINE, "Hosts Lookup thread done {0} host(s) found", HostsListTableModel.this.getRowCount());
                } else {
                    RemoteUtil.LOGGER.log(Level.FINE, "Hosts Lookup thread interrupted; {0} host(s) found so far", HostsListTableModel.this.getRowCount());
                }
            }
        }
    }

    private static class HostRecord {
        public final String name;
        public final String ip;
        public final boolean ssh;

        public HostRecord(String ip, String name, boolean ssh) {
            this.name = name;
            this.ip = ip;
            this.ssh = ssh;
        }

        public String toString() {
            return this.name + " [" + this.ip + "] " + (this.ssh ? "ssh" : "nossh");
        }
    }
}

