/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

class Attr {
    private static final int BGCOLORf = 0;
    private static final int BGCOLORw = 5;
    private static final int BGCOLORm = 15;
    public static final int BGCOLOR = 15;
    private static final int FGCOLORf = 5;
    private static final int FGCOLORw = 5;
    private static final int FGCOLORm = 15;
    public static final int FGCOLOR = 480;
    private static final int HIDDENf = 10;
    private static final int HIDDENw = 1;
    public static final int HIDDEN = 1024;
    private static final int REVERSEf = 11;
    private static final int REVERSEw = 1;
    public static final int REVERSE = 2048;
    private static final int BLINKf = 12;
    private static final int BLINKw = 1;
    public static final int BLINK = 4096;
    private static final int UNDERSCOREf = 13;
    private static final int UNDERSCOREw = 1;
    public static final int UNDERSCORE = 8192;
    private static final int BRIGHTf = 14;
    private static final int BRIGHTw = 1;
    public static final int BRIGHT = 16384;
    private static final int DIMf = 15;
    private static final int DIMw = 1;
    public static final int DIM = 32768;
    private static final int ACTIVEf = 16;
    public static final int ACTIVE = 65536;
    public static final int UNSET = 0x40000000;

    Attr() {
    }

    public static int setBackgroundColor(int attr, int code) {
        attr &= 0xFFFFFFF0;
        return attr |= (code &= 0xF) << 0;
    }

    public static int setForegroundColor(int attr, int code) {
        attr &= 0xFFFFFE1F;
        return attr |= (code &= 0xF) << 5;
    }

    public static int foregroundColor(int attr) {
        return attr >> 5 & 0xF;
    }

    public static int backgroundColor(int attr) {
        return attr >> 0 & 0xF;
    }

    public static int setAttribute(int attr, int value) {
        switch (value) {
            case 0: {
                attr = 0;
                break;
            }
            case 1: 
            case 5: {
                attr &= 0xFFFF7FFF;
                attr |= 0x4000;
                break;
            }
            case 2: {
                attr &= 0xFFFFBFFF;
                attr |= 0x8000;
                break;
            }
            case 4: {
                attr |= 0x2000;
                break;
            }
            case 7: {
                attr |= 0x800;
                break;
            }
            case 8: {
                attr |= 0x400;
                break;
            }
            case 9: {
                attr |= 0x10000;
                break;
            }
            case 22: 
            case 25: {
                attr &= 0xFFFF7FFF;
                attr &= 0xFFFFBFFF;
                break;
            }
            case 24: {
                attr &= 0xFFFFDFFF;
                break;
            }
            case 27: {
                attr &= 0xFFFFF7FF;
                break;
            }
            case 28: {
                attr &= 0xFFFFFBFF;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                attr = Attr.setForegroundColor(attr, value - 30 + 1);
                break;
            }
            case 39: {
                attr = Attr.setForegroundColor(attr, 0);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                attr = Attr.setBackgroundColor(attr, value - 40 + 1);
                break;
            }
            case 49: {
                attr = Attr.setBackgroundColor(attr, 0);
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                attr = Attr.setForegroundColor(attr, value - 50 + 9);
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                attr = Attr.setBackgroundColor(attr, value - 60 + 9);
                break;
            }
        }
        return attr;
    }

    public static int unsetAttribute(int attr, int value) {
        switch (value) {
            case 0: {
                attr = 0;
                break;
            }
            case 1: 
            case 5: {
                attr &= 0xFFFFBFFF;
                break;
            }
            case 2: {
                attr &= 0xFFFF7FFF;
                break;
            }
            case 4: {
                attr &= 0xFFFFDFFF;
                break;
            }
            case 7: {
                attr &= 0xFFFFF7FF;
                break;
            }
            case 8: {
                attr &= 0xFFFFFBFF;
                break;
            }
            case 9: {
                attr &= 0xFFFEFFFF;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                attr = Attr.setForegroundColor(attr, 0);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                attr = Attr.setBackgroundColor(attr, 0);
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                attr = Attr.setForegroundColor(attr, 0);
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                attr = Attr.setBackgroundColor(attr, 0);
                break;
            }
        }
        return attr;
    }
}

