/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.model.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.model.tasks.CsmFileTaskFactory;
import org.netbeans.modules.cnd.model.tasks.OpenedEditors;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public abstract class CaretAwareCsmFileTaskFactory
extends CsmFileTaskFactory {
    private static final RequestProcessor WORKER = new RequestProcessor("CaretAwareCsmFileTaskFactory worker");
    private Map<JTextComponent, ComponentListener> component2Listener = new HashMap<JTextComponent, ComponentListener>();
    private static Map<FileObject, Integer> file2LastPosition = new WeakHashMap<FileObject, Integer>();

    public CaretAwareCsmFileTaskFactory() {
        OpenedEditors.getDefault().addChangeListener(new ChangeListenerImpl());
    }

    public List<FileObject> getFileObjects() {
        List<FileObject> files = OpenedEditors.filterSupportedFiles(OpenedEditors.getDefault().getVisibleEditorsFiles());
        return files;
    }

    public static synchronized int getLastPosition(FileObject file) {
        if (file == null) {
            throw new NullPointerException("Cannot pass null file!");
        }
        Integer position = file2LastPosition.get(file);
        if (position == null) {
            return 0;
        }
        return position;
    }

    static synchronized void setLastPosition(FileObject file, int position) {
        file2LastPosition.put(file, position);
    }

    private class ComponentListener
    implements CaretListener {
        private JTextComponent component;
        private final RequestProcessor.Task rescheduleTask;

        public ComponentListener(JTextComponent component) {
            this.component = component;
            this.rescheduleTask = WORKER.create(new Runnable(){

                @Override
                public void run() {
                    FileObject file = OpenedEditors.getFileObject(ComponentListener.this.component);
                    if (file != null) {
                        CaretAwareCsmFileTaskFactory.setLastPosition(file, ComponentListener.this.component.getCaretPosition());
                        CaretAwareCsmFileTaskFactory.this.reschedule(file);
                    }
                }
            });
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            FileObject file = OpenedEditors.getFileObject(this.component);
            if (file != null) {
                CaretAwareCsmFileTaskFactory.setLastPosition(file, this.component.getCaretPosition());
                this.rescheduleTask.schedule(CaretAwareCsmFileTaskFactory.this.rescheduleDelay());
            }
        }
    }

    private class ChangeListenerImpl
    implements ChangeListener {
        private ChangeListenerImpl() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ArrayList<JTextComponent> added = new ArrayList<JTextComponent>(OpenedEditors.getDefault().getVisibleEditors());
            ArrayList removed = new ArrayList(CaretAwareCsmFileTaskFactory.this.component2Listener.keySet());
            added.removeAll(CaretAwareCsmFileTaskFactory.this.component2Listener.keySet());
            removed.removeAll(OpenedEditors.getDefault().getVisibleEditors());
            for (JTextComponent c : removed) {
                c.removeCaretListener((CaretListener)CaretAwareCsmFileTaskFactory.this.component2Listener.remove(c));
            }
            for (JTextComponent c : added) {
                ComponentListener l = new ComponentListener(c);
                c.addCaretListener(l);
                CaretAwareCsmFileTaskFactory.this.component2Listener.put(c, l);
                CaretAwareCsmFileTaskFactory.setLastPosition(OpenedEditors.getFileObject(c), c.getCaretPosition());
            }
            CaretAwareCsmFileTaskFactory.this.fileObjectsChanged();
        }
    }
}

