/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.AnnotationType;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.lib.editor.bookmarks.api.BookmarkList;
import org.netbeans.modules.editor.bookmarks.BookmarksPersistence;
import org.openide.modules.ModuleInstall;
import org.openide.util.WeakListeners;

class EditorBookmarksModule
extends ModuleInstall {
    private static final String DOCUMENT_TRACKER_PROP = "EditorBookmarksModule.DOCUMENT_TRACKER_PROP";
    private BookmarksInitializer bookmarksInitializer;
    private PropertyChangeListener annotationTypesListener;

    EditorBookmarksModule() {
    }

    public void restored() {
        BookmarksPersistence.init();
        this.bookmarksInitializer = new BookmarksInitializer();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final Iterator it = EditorRegistry.componentList().iterator();
                if (!it.hasNext()) {
                    return;
                }
                AnnotationType type = AnnotationTypes.getTypes().getType("editor-bookmark");
                if (type == null) {
                    EditorBookmarksModule.this.annotationTypesListener = new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            AnnotationType type = AnnotationTypes.getTypes().getType("editor-bookmark");
                            if (type != null) {
                                AnnotationTypes.getTypes().removePropertyChangeListener(EditorBookmarksModule.this.annotationTypesListener);
                                while (it.hasNext()) {
                                    JTextComponent jtc = (JTextComponent)it.next();
                                    BookmarkList.get(jtc.getDocument());
                                }
                            }
                        }
                    };
                    AnnotationTypes.getTypes().addPropertyChangeListener(EditorBookmarksModule.this.annotationTypesListener);
                } else {
                    while (it.hasNext()) {
                        BookmarkList.get(((JTextComponent)it.next()).getDocument());
                    }
                }
            }
        });
    }

    public boolean closing() {
        this.finish();
        return super.closing();
    }

    public void uninstalled() {
        this.finish();
    }

    private void finish() {
        BookmarksPersistence.destroy();
        if (this.bookmarksInitializer != null) {
            this.bookmarksInitializer.destroy();
        }
    }

    private class BookmarksInitializer
    implements PropertyChangeListener {
        private PropertyChangeListener documentListener;

        BookmarksInitializer() {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
            this.documentListener = WeakListeners.propertyChange((PropertyChangeListener)this, null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == EditorRegistry.class) {
                if (evt.getPropertyName() == null || "focusGained".equals(evt.getPropertyName())) {
                    JTextComponent jtc = (JTextComponent)evt.getNewValue();
                    BookmarkList.get(jtc.getDocument());
                    PropertyChangeListener l = (PropertyChangeListener)jtc.getClientProperty(EditorBookmarksModule.DOCUMENT_TRACKER_PROP);
                    if (l == null) {
                        jtc.putClientProperty(EditorBookmarksModule.DOCUMENT_TRACKER_PROP, this.documentListener);
                        jtc.addPropertyChangeListener(this.documentListener);
                    }
                }
                return;
            }
            if (evt.getSource() instanceof JTextComponent) {
                Document newDoc;
                if ((evt.getPropertyName() == null || "document".equals(evt.getPropertyName())) && (newDoc = (Document)evt.getNewValue()) != null) {
                    BookmarkList.get(newDoc);
                }
                return;
            }
        }

        void destroy() {
            EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }
}

