/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.CustomizerRun;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.CustomizerSources;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.GemRequirementsPanel;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubyProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RubyCompositePanelProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String SOURCES = "Sources";
    private static final String BUILD = "Build";
    private static final String GEMS = "Gems";
    public static final String RUN = "Run";
    private final String name;

    public RubyCompositePanelProvider(String name) {
        this.name = name;
    }

    public ProjectCustomizer.Category createCategory(Lookup context) {
        ResourceBundle bundle = NbBundle.getBundle(RubyCompositePanelProvider.class);
        ProjectCustomizer.Category toReturn = null;
        if (SOURCES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)SOURCES, (String)bundle.getString("LBL_Config_Sources"), null, (ProjectCustomizer.Category[])null);
        } else if (BUILD.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)BUILD, (String)bundle.getString("LBL_Config_Build"), null, (ProjectCustomizer.Category[])null);
        } else if (RUN.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)RUN, (String)bundle.getString("LBL_Config_Run"), null, (ProjectCustomizer.Category[])null);
        } else if (GEMS.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)GEMS, (String)bundle.getString("LBL_Config_Gems"), null, (ProjectCustomizer.Category[])null);
        }
        assert (toReturn != null) : "No category for name:" + this.name;
        return toReturn;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        String nm = category.getName();
        RubyProjectProperties uiProps = (RubyProjectProperties)context.lookup(RubyProjectProperties.class);
        if (SOURCES.equals(nm)) {
            return new CustomizerSources(uiProps);
        }
        if (RUN.equals(nm)) {
            return new CustomizerRun(uiProps);
        }
        if (GEMS.equals(nm)) {
            RubyBaseProject project = (RubyBaseProject)context.lookup(RubyBaseProject.class);
            return new GemRequirementsPanel(project, (SharedRubyProjectProperties)context.lookup(SharedRubyProjectProperties.class));
        }
        return new JPanel();
    }

    public static RubyCompositePanelProvider createSources() {
        return new RubyCompositePanelProvider(SOURCES);
    }

    public static RubyCompositePanelProvider createBuild() {
        return new RubyCompositePanelProvider(BUILD);
    }

    public static RubyCompositePanelProvider createRun() {
        return new RubyCompositePanelProvider(RUN);
    }

    public static RubyCompositePanelProvider createGems() {
        return new RubyCompositePanelProvider(GEMS);
    }
}

