/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.api;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class GroovyErrorOutputSupport {
    private static final String EXT = ".groovy";
    private static final String CAUGHT = "Caught: ";

    private static int findNumberBetween(String str, String left, String right) {
        int x0;
        int indexR;
        int indexL = str.indexOf(left);
        if (indexL != -1 && (indexR = str.indexOf(right, x0 = indexL + left.length())) != -1) {
            String numberSubstring = str.substring(indexL + left.length(), indexR).trim();
            try {
                int number = Integer.parseInt(numberSubstring);
                return number;
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        return -1;
    }

    public static HyperlinkData checkErrorLine(String line, FileObject fileObject) {
        String fileName = null;
        String message = line;
        int line1 = -1;
        int col1 = -1;
        if (line.startsWith("org.codehaus.groovy.control.MultipleCompilationErrorsException")) {
            StringTokenizer tokenizer = new StringTokenizer(line, ":", false);
            ArrayList<String> parts = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                parts.add(tokenizer.nextToken());
            }
            String fileNameToken = (String)parts.get(1);
            fileName = fileNameToken.substring(fileNameToken.indexOf(",") + 2);
            StringBuffer messageToken = new StringBuffer((String)parts.get(3));
            for (int i = 4; i < parts.size(); ++i) {
                messageToken.append(':');
                messageToken.append((String)parts.get(i));
            }
            message = messageToken.toString();
            line1 = GroovyErrorOutputSupport.findNumberBetween(message, "line", ",");
            col1 = GroovyErrorOutputSupport.findNumberBetween(message, "column", ".");
        } else {
            int extIndex;
            if (line.startsWith(CAUGHT)) {
                line = line.substring(CAUGHT.length());
            }
            if ((extIndex = line.indexOf(EXT)) == -1) {
                return null;
            }
            if (line.startsWith("Node: ")) {
                int beforeCoords = line.indexOf(" At [");
                if (beforeCoords == -1) {
                    return null;
                }
                line1 = GroovyErrorOutputSupport.findNumberBetween(line, " At [", ":");
                col1 = GroovyErrorOutputSupport.findNumberBetween(line.substring(beforeCoords), ":", "]");
                int beforeFileName = line.indexOf("] ", beforeCoords);
                if (beforeFileName == -1) {
                    return null;
                }
                fileName = line.substring(beforeFileName + 2);
            } else {
                fileName = line.substring(0, extIndex + EXT.length());
                line = line.substring(fileName.length());
                line1 = GroovyErrorOutputSupport.findNumberBetween(line, ":", ":");
                col1 = GroovyErrorOutputSupport.findNumberBetween(line.substring(1), ":", ":");
                if (col1 == -1) {
                    col1 = GroovyErrorOutputSupport.findNumberBetween(line, "column: ", ".");
                } else {
                    line = line.substring(line.indexOf(Integer.toString(line1)));
                }
                int colon2 = line.indexOf(":", 1);
                message = line.substring(colon2 + 1);
                if (message.length() == 0) {
                    message = null;
                }
            }
        }
        File file = FileUtil.normalizeFile((File)new File(fileName));
        if (!file.exists()) {
            Project prj = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (prj == null) {
                return null;
            }
            FileObject currentDir = prj.getProjectDirectory();
            FileObject executedFile = currentDir.getFileObject(fileName);
            if (executedFile != null) {
                file = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)executedFile));
            }
            if (file != null && !file.exists()) {
                return null;
            }
        }
        return new HyperlinkData(file, message, line1, col1, line1, col1);
    }

    public static class HyperlinkData {
        public File file;
        public String message;
        public int line1;
        public int column1;
        public int line2;
        public int column2;

        private HyperlinkData(File file, String message, int line1, int column1, int line2, int column2) {
            this.file = file;
            this.message = message;
            this.line1 = line1;
            this.column1 = column1;
            this.line2 = line2;
            this.column2 = column2;
        }
    }
}

