/*
 * Decompiled with CFR 0.152.
 */
package com.mentorgen.tools.profile.instrument;

import com.mentorgen.tools.profile.Controller;
import com.mentorgen.tools.profile.instrument.PerfClassAdapter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.objectweb.asm.jip.ClassReader;
import org.objectweb.asm.jip.ClassWriter;

public class Transformer
implements ClassFileTransformer {
    @Override
    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
        byte[] byArray2;
        if (string.startsWith("com/mentorgen/tools/profile") || string.startsWith("net/sourceforge/jiprof")) {
            return byArray;
        }
        if (Controller._includeList.length > 0) {
            boolean objectArray;
            boolean bl = false;
            String[] throwable = Controller._includeList;
            int n = throwable.length;
            for (int i = 0; i < n; ++i) {
                String string2 = throwable[i];
                if (!string.startsWith(string2)) continue;
                objectArray = true;
                break;
            }
            if (!objectArray) {
                if (Controller._debug) {
                    this.debug(classLoader, string, false);
                }
                return byArray;
            }
        }
        if (!Controller._filter.accept(classLoader)) {
            if (Controller._debug) {
                this.debug(classLoader, string, false);
            }
            return byArray;
        }
        for (String string3 : Controller._excludeList) {
            if (!string.startsWith(string3)) continue;
            if (Controller._debug) {
                this.debug(classLoader, string, false);
            }
            return byArray;
        }
        byte[] byArray3 = byArray;
        try {
            if (Controller._debug) {
                this.debug(classLoader, string, true);
            }
            ++Controller._instrumentCount;
            ClassReader classReader = new ClassReader(byArray);
            ClassWriter classWriter = new ClassWriter(1);
            PerfClassAdapter perfClassAdapter = new PerfClassAdapter(classWriter, string);
            classReader.accept(perfClassAdapter, 2);
            byArray2 = classWriter.toByteArray();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
        return byArray2;
    }

    private void debug(ClassLoader classLoader, String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("INST");
        } else {
            stringBuffer.append("skip");
        }
        stringBuffer.append("\t");
        stringBuffer.append(string);
        stringBuffer.append("\t");
        stringBuffer.append("[");
        stringBuffer.append(classLoader.getClass().getName());
        stringBuffer.append("]");
        System.out.println(stringBuffer.toString());
    }
}

